(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   4851695,      85283]
NotebookOptionsPosition[   4844329,      85177]
NotebookOutlinePosition[   4844766,      85194]
CellTagsIndexPosition[   4844723,      85191]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Sample playground", "Title",
 CellChangeTimes->{{3.8601397412505856`*^9, 
  3.860139755017807*^9}},ExpressionUUID->"d0e8ddea-97d3-4359-93ee-\
9734776dce2c"],

Cell[TextData[{
 "This notebook is used for the processing and fitting of one sample. It \
requires the functions in ",
 StyleBox["Polydisp fitting functions all data.nb",
  FontSlant->"Italic"],
 ".\nIntensity units are arbitrary as the patterns are rescaled for merging."
}], "Text",
 CellChangeTimes->{{3.8601397453382463`*^9, 3.8601397964528313`*^9}, {
  3.8617669288125243`*^9, 3.861766945139561*^9}, {3.8617673062268524`*^9, 
  3.8617673066939745`*^9}, {3.861942912912383*^9, 
  3.861942913146066*^9}},ExpressionUUID->"7c1a7862-4493-4bbd-ad86-\
2d905071e2e2"],

Cell[CellGroupData[{

Cell["Select and plot the data to be analyzed", "Subsubsection",
 CellChangeTimes->{{3.854421099868669*^9, 3.854421101948415*^9}, {
  3.8601398442554398`*^9, 
  3.8601398549474306`*^9}},ExpressionUUID->"44c23e06-c6ba-4d87-ae3e-\
52595994b93e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Join", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<C15_*\>\""}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Keys", "[", "sampleFiles", "]"}], ",", 
     RowBox[{"s_String", "/;", 
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"s", ",", "\"\<BG25_*\>\""}], "]"}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"testsamples", "=", "%"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"testsamples", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<171_1.4002\>\"", ",", "\"\<171_30.9999\>\"", ",", 
       "\"\<171_9.99982\>\"", ",", "\"\<171_9.99999\>\""}], "}"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.843296948142498*^9, 3.843296958212912*^9}, {
   3.8432972784145517`*^9, 3.8432973057271643`*^9}, {3.8432977131560783`*^9, 
   3.843297716018899*^9}, {3.843298309901671*^9, 3.84329834918407*^9}, 
   3.843298997733918*^9, {3.8432990321174*^9, 3.843299072004407*^9}, {
   3.843299122424327*^9, 3.843299133661518*^9}, {3.843299265884342*^9, 
   3.84329926858108*^9}, {3.843300103749148*^9, 3.843300112466827*^9}, {
   3.8527849855621357`*^9, 3.852784994200242*^9}, {3.852787417047249*^9, 
   3.852787424091958*^9}, {3.8527874789702*^9, 3.8527874801375923`*^9}, {
   3.852787728214538*^9, 3.852787778738393*^9}, {3.8527968489630823`*^9, 
   3.8527968515622187`*^9}, {3.8527969362639837`*^9, 3.852796936383173*^9}, {
   3.8527970088774014`*^9, 3.8527970089163847`*^9}, {3.853836617160633*^9, 
   3.853836617592147*^9}, {3.854421141973649*^9, 3.854421142035899*^9}, {
   3.8544211928939333`*^9, 3.854421193010366*^9}, {3.860120705408345*^9, 
   3.860120705446088*^9}, {3.8617632879814606`*^9, 3.861763304765732*^9}, {
   3.8617673092767124`*^9, 3.8617673185406885`*^9}, {3.8859734491964083`*^9, 
   3.885973455500765*^9}, {3.8859747794365234`*^9, 3.8859748137649736`*^9}, {
   3.8859750181935196`*^9, 3.885975018432844*^9}, {3.8859763176629515`*^9, 
   3.8859763198468237`*^9}, {3.8859770271978893`*^9, 
   3.8859770297569485`*^9}, {3.8859774963407874`*^9, 3.885977500029621*^9}, {
   3.8859790256696296`*^9, 3.8859790880678005`*^9}, {3.8859792862203617`*^9, 
   3.885979303353922*^9}, {3.885979636059869*^9, 3.885979636325242*^9}, {
   3.8859798673963566`*^9, 3.885979867979951*^9}, {3.8859802087472224`*^9, 
   3.8859802091063414`*^9}, 3.8859802670443172`*^9, {3.8859805336112413`*^9, 
   3.8859805370509305`*^9}, {3.885980676883481*^9, 3.8859806770585265`*^9}, {
   3.8860615694895253`*^9, 3.8860615965610476`*^9}, {3.8902035063775234`*^9, 
   3.8902035070815973`*^9}, {3.8914267029333563`*^9, 3.8914267032050333`*^9}},
 CellLabel->
  "In[2058]:=",ExpressionUUID->"288b6ba3-0e36-41d8-949e-a2c664f880eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C15_30.7138\"\>", ",", "\<\"C15_10.0042\"\>", 
   ",", "\<\"C15_1.504\"\>", ",", "\<\"BG25_30.7138\"\>", 
   ",", "\<\"BG25_10.0042\"\>", ",", "\<\"BG25_1.504\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.85278774182577*^9, 3.8527877823161783`*^9}, 
   3.852796852362589*^9, 3.852796937189692*^9, 3.852797010008708*^9, 
   3.8528624946560097`*^9, 3.853381366643115*^9, 3.853381473062273*^9, 
   3.8534022376061707`*^9, 3.85346909236896*^9, 3.8534962759553757`*^9, 
   3.8534996218158073`*^9, 3.853817842919454*^9, 3.853818242802884*^9, 
   3.853824682294836*^9, 3.853824869851644*^9, 3.853833074084684*^9, 
   3.853836452539434*^9, 3.8538366226871643`*^9, 3.8538385385329847`*^9, 
   3.854072553810278*^9, 3.85409167434895*^9, 3.854098459654634*^9, 
   3.854420757546021*^9, 3.854421148417843*^9, 3.8544211935109262`*^9, 
   3.8544236425084476`*^9, 3.860120714271991*^9, {3.8601208146323557`*^9, 
   3.860120817823097*^9}, 3.8601209904370317`*^9, {3.8601401966367846`*^9, 
   3.8601402016808*^9}, {3.8601411929801598`*^9, 3.860141197066132*^9}, 
   3.8617633119613857`*^9, 3.8617673196071157`*^9, 3.861941017862147*^9, 
   3.8619433170388165`*^9, 3.861950007077615*^9, 3.861950097594084*^9, 
   3.861950313053934*^9, 3.8859734561647086`*^9, 3.8859735723144336`*^9, {
   3.8859747343360167`*^9, 3.8859747430702314`*^9}, 3.8859747970713787`*^9, 
   3.8859750198706293`*^9, 3.885976323503401*^9, 3.8859770304553003`*^9, 
   3.885977536755321*^9, {3.885979057328891*^9, 3.885979092434539*^9}, {
   3.8859792905705223`*^9, 3.885979306593282*^9}, 3.8859796400840683`*^9, 
   3.885979871667265*^9, 3.8859802113912177`*^9, 3.8859802706713324`*^9, 
   3.885980540538966*^9, 3.8859806802452884`*^9, 3.886061601230296*^9, 
   3.8861522211573744`*^9, 3.8883109765610237`*^9, 3.8890022652170677`*^9, 
   3.8890603226490602`*^9, 3.88906456673145*^9, 3.889081912662714*^9, 
   3.88908274923429*^9, 3.889084479032218*^9, {3.8895035587135143`*^9, 
   3.8895035763897266`*^9}, 3.8895042359682283`*^9, 3.889668723612721*^9, 
   3.890203509837488*^9, 3.89020358352724*^9, 3.8909804837292213`*^9, 
   3.89098153769302*^9, 3.890982738443742*^9, 3.8914160072605443`*^9, 
   3.891426705322385*^9, 3.8926185843467875`*^9, 3.8926186672660875`*^9, 
   3.9023676097936296`*^9},
 CellLabel->
  "Out[2058]=",ExpressionUUID->"bba292a0-243b-413d-9bde-a3c2de8368be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"dataToPlot", "=", 
   RowBox[{"scatteringDataSampleAveraged", "/@", "testsamples"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"plotDataRaw", " ", "=", " ", 
  RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
   RowBox[{"dataToPlot", ",", "\[IndentingNewLine]", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotLegends", "\[Rule]", "testsamples"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameTicks", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
    " ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
      " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
      "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"LabelStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
      "}"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"5", " ", 
          RowBox[{"10", "^", 
           RowBox[{"-", "3"}]}]}], ",", 
         RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", " ", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.01", ",", " ", "0.1", ",", " ", "1"}], "}"}], ",", 
        RowBox[{"{", "Automatic", "}"}], ",", " ", "None", ",", " ", "None"}],
        "}"}], ",", " ", 
      RowBox[{"FrameTicks", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
        "LogTicks", ",", "LinTicks", ",", " ", "None", ",", " ", "None"}], 
        "}"}]}]}], " ", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
      "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
      "\"\<DataRaw.pdf\>\""}], "}"}], "]"}], ",", "plotDataRaw"}], " ", 
  "]"}]}], "Input",
 CellChangeTimes->{{3.84329809635746*^9, 3.843298105573452*^9}, {
   3.84329815837682*^9, 3.843298163080853*^9}, {3.843298211914578*^9, 
   3.8432982378108053`*^9}, {3.843298288845417*^9, 3.843298291452414*^9}, 
   3.843298361191868*^9, {3.84329871517915*^9, 3.843298719649724*^9}, {
   3.843299850907208*^9, 3.843299962957724*^9}, {3.843300008752656*^9, 
   3.8433000099440603`*^9}, {3.8433000666678867`*^9, 3.843300081842258*^9}, 
   3.8433001270605783`*^9, 3.852785029476323*^9, {3.8527875156086903`*^9, 
   3.852787529623748*^9}, {3.852787908039447*^9, 3.852787908637274*^9}, {
   3.88951548143122*^9, 3.88951548156557*^9}, {3.8896687353498526`*^9, 
   3.8896687417207317`*^9}, {3.8896725688232393`*^9, 3.889672590126113*^9}, {
   3.889672623190502*^9, 3.8896726983115826`*^9}, {3.889672740640524*^9, 
   3.889672758876796*^9}, {3.8896729834503565`*^9, 3.889673069010479*^9}, {
   3.889673142722207*^9, 3.8896731964734883`*^9}, {3.889676349237294*^9, 
   3.8896763709122796`*^9}, {3.889692253576544*^9, 3.889692254563936*^9}},
 CellLabel->
  "In[2060]:=",ExpressionUUID->"6ebf2b6c-fd73-4115-90fc-264fde664a3f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81e8Xv/vae4QUGkhFpG/m55OQkVEqCZWkVIoko5QGoqWkyMwIKSEi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         "]], 
        LineBox[{{-1.3940446702383194`, -5.298317366548036}, \
{-1.3937713946822754`, -2.5038624927724347`}, {-1.3931625929004259`, \
-2.378720414358653}, {-1.3925541015537621`, -3.7755949974100034`}}], 
        LineBox[{{-1.3907309656742075`, -4.7153277122964266`}, \
{-1.3901239517057393`, -2.181257217770447}, {-1.3896104331752048`, \
-5.298317366548036}}], 
        LineBox[{{-1.3883052369189728`, -3.6275601255778898`}, \
{-1.387699693172116, -2.0293446079787656`}, {-1.3870945755389497`, \
-2.050710100190793}, {-1.3864897642354097`, -1.4887261619533523`}, \
{-1.3858853185074895`, -5.057656786525843}, {-1.3852813570020988`, \
-1.6409318993477156`}, {-1.3846776410293211`, -4.058873404829124}}], 
        LineBox[{{-1.3792607728631248`, -1.1930886670592282`}, \
{-1.3786606796064136`, 1.4405861725661109`}}]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3k8lN8XHsbYxwyyVb6lqCRbKSRmSKSipMWetChLpKSSXRFlp0hUkkqL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         "]], 
        LineBox[{{-0.26376300586024654`, -5.298317366548036}, \
{-0.26316406728534836`, -4.995538352414441}, {-0.2628247455426462, \
-5.298317366548036}}], 
        LineBox[{{-0.2619325576566468, -5.298317366548036}, \
{-0.26135511287304525`, -4.44409652271556}, {-0.26096476665754115`, \
-5.298317366548036}}], 
        LineBox[{{-0.25981048950349606`, -5.298317366548036}, \
{-0.2595494248689136, -3.392489257015948}, {-0.25894830418020226`, \
-4.704241504096463}}]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUmnc8Vn8Ux+2d8TwtoSVJRBEl6qhUv6IoSimjkDKKEhkNtIQQJRHJSCWS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         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c8lf8Xv3svW1RERkhIZd9LZSYkZURJSkmkIqlERltJKErFFylFiSie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         "]], 
        LineBox[CompressedData["
1:eJw9VXs81HkXJol1mfn9ZohqSYnaVjFha9uwNC7pjVxKF0XETrFZUVFEW2Fd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         "]], 
        LineBox[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAAA1e6lA9s+L9TnJQbejEVwP7vBVJt
afi/KwexYvqTEMBuhDfZlGb4v4G41IfQEhHANWY/9Lxj+L+sTbaTXd0TwCiY
L37lYPi/6QwJmIU6EcDHspObDl74v9Oj2P5p8Q7AF/WKJzhb+L8tWq4rcxIR
wK8hlEZiWPi/VLcPJobEEMBCqtvTjFX4v/kp0z8iGhLAcYTT87dS+L9ro26C
/n4QwCJLtYHjT/i/xdbTyN3dDcDwL+ahD034v/XH368rDhDAgu2sLzxK+L9s
8ilfsAoTwE36YU9pR/i/kG1RpE0FFcBXJ1nclkT4v47sEZ/pjRLAyDje+sRB
+L/tYxK54HkQwKgMUobzPvi/orxxmXVxEcCjvfOiIjz4v/dhaL/Fuw/Aci0x
LFI5+L8dJs2vqwYOwAvWPEaCNvi/yn5AxbdUDsCRk5HMsjP4v9Ah3vg3ShHA
BEhV4+Mw+L8BEwbWHIATwK/AD2YVLvi/NlmOEQlEE8BVUNp4Ryv4vwJeC/x4
sxHAN6xJ93ko+L9O+LCJR7QQwIGgagWtJfi/lFwCVvRFEsBEwd5+4CL4v99e
iR6cixHAulymhxQg+L84SH4K5x0RwKDcb/tIHfi/ggzFBxPVD8DaGS/+fRr4
v7E38w/zPBDAvEqfa7MX+L9MRfarZx0VwGTbp2fpFPi/W0ml1bVpFMCvxRDO
HxL4v7pfJnm8MRHAS515al4P+L9TnJQbejEVwMkMGbo=
         "]], 
        LineBox[{{-1.5037373115477313`, -5.298317366548036}, \
{-1.5030652337220112`, -4.331103292784053}, {-1.5023861452440905`, \
-5.176982644281236}, {-1.5017074507178931`, -5.233671505510157}, \
{-1.501029283356703, -4.187777142744001}, {-1.500351508788963, \
-5.122999128780635}, {-1.49967426004908, -3.9248989701165513`}, \
{-1.4989974029491981`, -4.94981402959598}, {-1.4983210703453254`, \
-3.970192279352568}, {-1.4976451282328034`, -4.509504977213211}, \
{-1.497282419903845, -5.298317366548036}}], 
        LineBox[CompressedData["
1:eJwBUQGu/iFib1JlAgAAABQAAAACAAAApneL4K/y979TnJQbejEVwHlwp7DS
8Pe/oCqk+TMhD8Dl+dtqD+73v0LfRKfBaxDAq/xFjUzr97+wKLB5IB4QwCSv
ajuK6Pe/iztDK8POEMAu5nZRyOX3v6NI1Xw7PxTA/88W4Qbj97/taga8RD0U
wBZq6vtF4Pe/1HrsTwxPE8DKMzF+hd33v3fKU7yUUg7A2R9Si8Xa97/4atrb
9LMPwFwUmf8F2Pe/arFhx2pfFMBr92D+RtX3v0BwMCS87hTAPA0CZIjS979q
SzeSOZEPwGg3y1PKz/e/hxvGkWfoDMCsDyGqDM33v8dW61hyCRXAQHtGik/K
978Vo+tpvI0RwNlgrNCSx/e/Z/RZdD4eEcBksYmg1sT3v6Zq+TaG0w3ACJhb
1hrC97/p9UiKYJYQwO8768mUwPe/U5yUG3oxFcBLt7NN
         "]], 
        LineBox[{{-1.483886653499008, -5.298317366548036}, \
{-1.4835555326370005`, -4.39705131516282}, {-1.4828895602005607`, \
-4.401750227067394}, {-1.482223965382512, -4.374087933670677}, \
{-1.4815588788483816`, -3.9384168175040464`}, {-1.4812637138944458`, \
-5.298317366548036}}], 
        LineBox[{{-1.4803310403373955`, -5.298317366548036}, \
{-1.4802299658562001`, -4.992724114168252}, {-1.480130607317852, \
-5.298317366548036}}], 
        LineBox[{{-1.4790167876091118`, -5.298317366548036}, \
{-1.4789028165302598`, -4.938134008965426}, {-1.478239869107999, \
-5.0622434804610075`}, {-1.4775774261954666`, -3.3915402251370703`}, \
{-1.4769153565646709`, -4.558825204390678}, {-1.4762537901952915`, \
-5.058448137319012}, {-1.4755925960345126`, -4.0385819735202935`}, \
{-1.4749775546448352`, -5.298317366548036}}], 
        LineBox[{{-1.4746371640347773`, -5.298317366548036}, \
{-1.4742715828886581`, -5.1823414383079065`}, {-1.4736117626649108`, \
-4.982317778518238}, {-1.4729523125165611`, -3.931031150665172}, \
{-1.4722933619135883`, -3.726149987245192}, {-1.4716347803258993`, \
-3.82044712941299}, {-1.4709766970544564`, -4.794451356971668}, \
{-1.470569512613433, -5.298317366548036}}], 
        LineBox[{{-1.4699900741939378`, -5.298317366548036}, \
{-1.4696617635223481`, -4.988863228633127}, {-1.4690049122101352`, \
-4.9862082416072315`}, {-1.4683990314453386`, -5.298317366548036}}], 
        LineBox[{{-1.4683340010489607`, -5.298317366548036}, \
{-1.467692567190646, -4.152511638544663}, {-1.467037072268365, \
-4.16446176460503}, {-1.4663819421636302`, -4.217548623597961}, \
{-1.4657273055057047`, -4.7324541834001455`}, {-1.465073032626457, \
-3.4151974642051353`}, {-1.4647478434084786`, -5.298317366548036}}], 
        LineBox[{{-1.4639294832167207`, -5.298317366548036}, \
{-1.4637658340941535`, -4.6625171875140605`}, {-1.4635861917095527`, \
-5.298317366548036}}], 
        LineBox[{{-1.4626413805310627`, -5.298317366548036}, \
{-1.4624603420993125`, -4.655187661493137}, {-1.4622737460920365`, \
-5.298317366548036}}], 
        LineBox[{{-1.4603921544184328`, -5.298317366548036}, \
{-1.4598544599396643`, -3.3016071198731365`}, {-1.459204016997299, \
-4.681394983523469}, {-1.458630550877732, -5.298317366548036}}], 
        LineBox[{{-1.4573737786764684`, -5.298317366548036}, \
{-1.4572553507560915`, -4.6081576337074575`}, {-1.4570061472398073`, \
-5.298317366548036}}], 
        LineBox[{{-1.4562430340056267`, -5.298317366548036}, \
{-1.455958325045854, -4.431771799698098}, {-1.4553104105673174`, \
-3.6884219517704806`}, {-1.4546629794324164`, -3.7875887872405443`}, \
{-1.454015903412415, -4.424856977366221}, {-1.4533693095687956`, \
-4.779929861161433}, {-1.4527230698400555`, -4.210198452513272}, \
{-1.4520773111248584`, -4.726138237648436}, {-1.4514319055284977`, \
-3.809659189144794}, {-1.4507869797872333`, -3.6576939636188914`}}], 
        LineBox[{{-1.4494595020042143`, -5.298317366548036}, \
{-1.4488545674843287`, -4.88190758788891}, {-1.4482113012607243`, \
-4.991634932671452}, {-1.4475683851914845`, -4.404280576219742}, \
{-1.446925945528132, -5.058222512174203}, {-1.4465574513315533`, \
-5.298317366548036}}], 
        LineBox[{{-1.4462147731221693`, -5.298317366548036}, \
{-1.445642239814265, -3.820915009826304}, {-1.4450009727872855`, \
-4.487892130493094}, {-1.4443601798882761`, -3.689620948818113}, \
{-1.4437197342142167`, -4.1859897494254525`}, {-1.4430797615355704`, \
-4.521661853962425}, {-1.4424401351130984`, -3.4512697536520935`}, \
{-1.4418009805577212`, -4.25023259330421}, {-1.4416042175553077`, \
-5.298317366548036}}], 
        LineBox[{{-1.4406928177346845`, -5.298317366548036}, \
{-1.4405238327723882`, -4.450565730070384}, {-1.4401712215799982`, \
-5.298317366548036}}], 
        LineBox[{{-1.4396163915314673`, -5.298317366548036}, \
{-1.4392483140132346`, -4.3610435177695415`}, {-1.438611132817861, \
-4.873463190028933}, {-1.4379744201298463`, -3.9908319487200803`}, \
{-1.437387973634555, -5.298317366548036}}], 
        LineBox[{{-1.4347967358750486`, -4.651005338914097}, \
{-1.434162446467272, -5.125227008565867}}], 
        LineBox[{{-1.4328950108984277`, -4.356067813256831}, \
{-1.4322618637985587`, -4.393001183791281}, {-1.4316291796892966`, \
-4.893982783803193}, {-1.4313152749202462`, -5.298317366548036}}], 
        LineBox[{{-1.429102314139286, -3.7975380561614918`}, \
{-1.428471563070626, -3.5806928834518836`}, {-1.428054099927964, \
-5.298317366548036}}], 
        LineBox[{{-1.427063380108268, -5.298317366548036}, \
{-1.4265817554936695`, -3.3967932259575795`}, {-1.42595265378466, \
-5.001251158093977}, {-1.4253238856188197`, -3.9803091493548735`}, \
{-1.424695574492021, -2.7125261171725916`}, {-1.4240675959930522`, \
-4.565336714721569}, {-1.423440073463934, -3.5096303820731847`}, \
{-1.4230640573350464`, -5.298317366548036}}], 
        LineBox[{{-1.4205899318224064`, -5.298317366548036}, \
{-1.4203081690295074`, -3.935636994726556}, {-1.4196830004606906`, \
-3.9113641821774228`}, {-1.4193428567564446`, -5.298317366548036}}], 
        LineBox[{{-1.4178097133274605`, -4.0750369361463985`}, \
{-1.4171861042786886`, -3.1460246966053}, {-1.4165628224394424`, \
-3.514548710088936}, {-1.4159399902365912`, -3.9104830761884}, \
{-1.4153650725124158`, -5.298317366548036}}], 
        LineBox[{{-1.4143543716746851`, -5.298317366548036}, \
{-1.414073695203434, -3.778047679104936}, {-1.4137264541023669`, \
-5.298317366548036}}], 
        LineBox[{{-1.4096183420134631`, -5.298317366548036}, \
{-1.4091139512378517`, -3.6865429357371795`}, {-1.408759986598989, \
-5.298317366548036}}], 
        LineBox[{{-1.4082412080315263`, -5.298317366548036}, \
{-1.407877849340566, -3.580615504897623}, {-1.40746819022165, \
-5.298317366548036}}], 
        LineBox[{{-1.4070536129033233`, -5.298317366548036}, \
{-1.406643273505007, -3.569438934928174}, {-1.4060265870799868`, \
-3.9277720571367136`}, {-1.4054102199677423`, -4.234246477078686}}], 
        LineBox[{{-1.403562249878592, -5.298317366548036}, \
{-1.4029486648038185`, -3.50232074803919}, {-1.4027706951203969`, \
-5.298317366548036}}], 
        LineBox[{{-1.400840577054237, -5.298317366548036}, \
{-1.4004931540181937`, -3.1121560601199656`}, {-1.3998802474910017`, \
-3.325239376225763}}], 
        LineBox[{{-1.398655499903949, -4.120282342546367}, \
{-1.398043657999477, -3.557972110479627}}], 
        LineBox[{{-1.3931625929004259`, -5.250416840132505}, \
{-1.3925541015537621`, -2.861298478622127}, {-1.3919460401861279`, \
-3.31801981184503}, {-1.391338288426397, -3.493553549565278}}], 
        LineBox[{{-1.3895173657767712`, -3.6246956952954177`}, \
{-1.3889110878104278`, -2.8870540138682053`}}], 
        LineBox[{{-1.4308119554125818`, -5.298317366548036}, \
{-1.4303649487833152`, -4.306568202162434}}]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.528488, 0.470624, 0.701351], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWnc81e8Xt/e891pJkpE9olBkJBIZaZDxLRSJRImyQnZJWkhUFIpQRBnn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         "]], 
        LineBox[{{-0.274677743164378, -5.298317366548036}, \
{-0.27408705585431015`, -4.969485974757601}, {-0.273598930718067, \
-5.298317366548036}}], 
        LineBox[{{-0.2721308661865039, -5.298317366548036}, \
{-0.27164944546190495`, -5.099040171584874}, {-0.2710409310817236, \
-4.827102489230139}, {-0.27043278676611493`, -5.190183761590067}, \
{-0.27011722996158055`, -5.298317366548036}}], 
        LineBox[{{-0.2692932393090027, -5.298317366548036}, \
{-0.2692176845490116, -5.284095850375458}, {-0.268610647684061, \
-4.678386890519318}, {-0.26800405701359853`, -4.410781081388414}, \
{-0.2673977561952779, -4.831118370141682}, {-0.2671970924629547, \
-5.298317366548036}}], 
        LineBox[{{-0.2656315760385054, -5.298317366548036}, \
{-0.26558113396476035`, -5.285816629941033}, {-0.26497629994481253`, \
-4.720271339889647}, {-0.2643719091696942, -5.228139952607627}, \
{-0.26376780586728016`, -5.03739343249013}, {-0.26316406728534836`, \
-5.08188885025199}, {-0.262560770485036, -5.087528578106296}, \
{-0.26195775997776694`, -4.836499833344438}, {-0.26135511287304525`, \
-4.633771593023157}, {-0.26075290609440566`, -4.760675184375608}, \
{-0.26015098443578805`, -4.607324334564698}, {-0.2595494248689136, \
-4.364465508880019}, {-0.25894830418020226`, -3.4429375320786066`}}]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[
          NCache[
           Rational[1, 360], 0.002777777777777778]], 
         RGBColor[0.772079, 0.431554, 0.102387], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwcW3c8Vf8bt0cq4mqhpZCVFGU+9KVFEcrILKVsESmpNFFRRlZKIrOEklHn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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.487195066484062, -5.298317366548025}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.487195066484062, 
      1.6310721412512184`}, {-5.298317366548036, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"C15_30.7138\"", "\"C15_10.0042\"", "\"C15_1.504\"", 
       "\"BG25_30.7138\"", "\"BG25_10.0042\"", "\"BG25_1.504\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.922526, 0.385626, 0.209179]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.528488, 0.470624, 0.701351]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", 
                    FractionBox["1", "360"], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.772079, 0.431554, 0.102387]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                 ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914267278210635`*^9, 
   3.8926186725375676`*^9, 3.90236763332272*^9},
 CellLabel->
  "Out[2061]=",ExpressionUUID->"da550308-601d-45cf-86fb-e761d01f09fa"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C15 - \
1.05\\\\DataRaw.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.843298149991452*^9, 3.843298203872168*^9, 3.8432982736696587`*^9, {
   3.843298384765218*^9, 3.843298404726954*^9}, 3.84329873022256*^9, {
   3.8432988004009867`*^9, 3.843298803824133*^9}, {3.843298872108584*^9, 
   3.843298895599083*^9}, {3.8432990149186*^9, 3.8432990770538588`*^9}, {
   3.843299137189081*^9, 3.8432991407725573`*^9}, {3.843299840648491*^9, 
   3.843299921480537*^9}, {3.843299960469057*^9, 3.843299972052854*^9}, 
   3.843300012041739*^9, 3.843300096769802*^9, {3.8433001291250687`*^9, 
   3.843300174678563*^9}, {3.852785009054036*^9, 3.852785030774148*^9}, {
   3.852787502594598*^9, 3.852787530539609*^9}, 3.852787791379717*^9, 
   3.852787910287105*^9, 3.852796869163835*^9, 3.8527969417886457`*^9, {
   3.852797012104776*^9, 3.852797018397952*^9}, 3.852862497566475*^9, 
   3.853381366813589*^9, 3.8533814753005857`*^9, 3.853402239868787*^9, 
   3.853469094796208*^9, 3.853496279768393*^9, 3.853499624685063*^9, 
   3.853817846160879*^9, 3.853818247955379*^9, 3.8538246853293123`*^9, 
   3.8538248725516987`*^9, 3.853833076731237*^9, 3.853836454739139*^9, 
   3.853836627576047*^9, 3.8538385410146437`*^9, 3.8540725564096527`*^9, 
   3.854091676757815*^9, 3.854098462801889*^9, 3.8544207604946127`*^9, 
   3.854421164446437*^9, 3.8544212040376797`*^9, 3.8544236563123503`*^9, 
   3.860120820146564*^9, 3.860120992755413*^9, 3.8601402097736197`*^9, 
   3.860141203197979*^9, 3.8617633271887465`*^9, 3.8617673254490795`*^9, 
   3.861941023959653*^9, 3.8619503178258157`*^9, 3.885973462316798*^9, {
   3.8859735791689806`*^9, 3.8859735863327785`*^9}, 3.8859747465859413`*^9, 
   3.8859747986681952`*^9, {3.885975027787902*^9, 3.8859750393330336`*^9}, 
   3.885976328509342*^9, 3.885977032989354*^9, 3.8859775404716673`*^9, 
   3.885979060483423*^9, 3.8859790972689905`*^9, {3.885979294595189*^9, 
   3.885979310657553*^9}, 3.885979644422537*^9, 3.8859798767472997`*^9, 
   3.8859802200758305`*^9, 3.885980276257719*^9, 3.885980545153112*^9, 
   3.885980685497188*^9, 3.8860616074751854`*^9, 3.886152225682108*^9, 
   3.888310978040262*^9, 3.889002269915166*^9, 3.8890603306392736`*^9, 
   3.889064568176372*^9, 3.889081913918378*^9, 3.8890827504249163`*^9, 
   3.889084480239011*^9, {3.8895035588509493`*^9, 3.8895035673865147`*^9}, {
   3.8895042405971904`*^9, 3.889504241091606*^9}, 3.88951548578316*^9, {
   3.8896687291557455`*^9, 3.889668742820923*^9}, 3.8896725906682463`*^9, 
   3.889672649616415*^9, 3.8896726992702703`*^9, {3.889672743456319*^9, 
   3.8896727596135435`*^9}, {3.889672989005809*^9, 3.889673014473555*^9}, 
   3.889673069643585*^9, {3.88967314352767*^9, 3.8896731597222066`*^9}, 
   3.8896731975865993`*^9, 3.8896763716560993`*^9, 3.890203528371027*^9, 
   3.8902035960444994`*^9, 3.8909804917392635`*^9, 3.8909815443374186`*^9, 
   3.8909827436668806`*^9, 3.8914160422882376`*^9, 3.8914267278210635`*^9, 
   3.8926186725375676`*^9, 3.902367637026187*^9},
 CellLabel->
  "Out[2062]=",ExpressionUUID->"c19afa5d-6ccf-49cf-8e87-87fd4f175250"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Process data", "Subsubsection",
 CellChangeTimes->{{3.8601399392765074`*^9, 3.8601399407209606`*^9}, {
   3.8859798317515917`*^9, 3.885979836205883*^9}, 
   3.8896895105228753`*^9},ExpressionUUID->"c68dbf72-8a8c-4c44-a3ef-\
9c60b7918969"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Subtract", " ", "backgrounds"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataToAnalyze", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
        RowBox[{
        "\"\<C15_30.7138\>\"", ",", "\"\<BG25_30.7138\>\"", ",", "1.05"}], 
        "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<C15_10.0042\>\"", ",", "\"\<BG25_10.0042\>\"", ",", "1.05"}], 
         "]"}], ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"wat", " ", "doen", " ", "de", " ", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"0", ",", "4"}], "}"}]}], "}"}], "?", " ", "--"}]}], 
         ">", " ", 
         RowBox[{
         "vermenigvuldig", " ", "alle", " ", "intensity", " ", "waardes", " ",
           "met", " ", "4"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"scatteringDataSampleAveragedSubtracted", "[", 
         RowBox[{
         "\"\<C15_1.504\>\"", ",", "\"\<BG25_1.504\>\"", ",", "1.05"}], "]"}],
         ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotDataSubtracted", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"dataToAnalyze", ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<31 m\>\"", ",", " ", "\"\<10 m\>\"", ",", " ", "\"\<1.5 m\>\""}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "5"}]}], ",", 
           RowBox[{"10", "^", "5"}]}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataSubtracted.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataSubtracted"}], " ", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.852787913735702*^9, 3.852788081126293*^9}, {
   3.852788124237091*^9, 3.852788221803185*^9}, {3.85278830511749*^9, 
   3.852788314820683*^9}, 3.852788353883409*^9, {3.8527951901832237`*^9, 
   3.852795266554426*^9}, {3.852795790301991*^9, 3.852795801188776*^9}, {
   3.8534052664208517`*^9, 3.853405359776355*^9}, 3.853405404221602*^9, {
   3.853409748113482*^9, 3.8534097682258587`*^9}, 3.853410243789892*^9, {
   3.853410568646674*^9, 3.853410593142272*^9}, {3.8538366552098618`*^9, 
   3.853836688425962*^9}, {3.8544213058580093`*^9, 3.8544213392155523`*^9}, {
   3.854421399974036*^9, 3.854421487835609*^9}, {3.860120980130918*^9, 
   3.8601209825914593`*^9}, {3.8601399447486825`*^9, 3.860139952932967*^9}, {
   3.861763386455724*^9, 3.8617634066433244`*^9}, {3.8617636721585855`*^9, 
   3.8617636911551275`*^9}, 3.861763753820904*^9, {3.861763829259494*^9, 
   3.8617638295877748`*^9}, {3.8617640171756115`*^9, 
   3.8617640685814066`*^9}, {3.861764108969255*^9, 3.8617641095314784`*^9}, {
   3.8617641469152203`*^9, 3.8617641470504246`*^9}, {3.8617642667147017`*^9, 
   3.861764269211673*^9}, {3.861764301965845*^9, 3.8617643679072943`*^9}, {
   3.861764616394006*^9, 3.861764629873103*^9}, {3.8617647074999027`*^9, 
   3.861764707889408*^9}, {3.861767331688716*^9, 3.8617674531915107`*^9}, {
   3.8619430250008717`*^9, 3.8619430252780623`*^9}, 3.885975125250722*^9, {
   3.885975162956421*^9, 3.8859751687928877`*^9}, {3.885975253564953*^9, 
   3.885975292171652*^9}, {3.8859753684038987`*^9, 3.8859753944654756`*^9}, {
   3.8859764080472107`*^9, 3.885976444462107*^9}, {3.8859766205505714`*^9, 
   3.885976701234559*^9}, {3.885977061431158*^9, 3.885977105613533*^9}, {
   3.8859775666625447`*^9, 3.8859775972455435`*^9}, {3.8859793109661627`*^9, 
   3.8859793451759176`*^9}, {3.8859793845178595`*^9, 
   3.8859794119426813`*^9}, {3.8859794524741387`*^9, 3.885979469919469*^9}, {
   3.8859796644128475`*^9, 3.8859797943053474`*^9}, {3.885979909660304*^9, 
   3.885979925707234*^9}, {3.885980058912956*^9, 3.8859800719340887`*^9}, {
   3.8859802956113253`*^9, 3.885980299515154*^9}, {3.8859803946280155`*^9, 
   3.8859804083447933`*^9}, {3.8859805548112154`*^9, 3.885980558763019*^9}, {
   3.8859806884189878`*^9, 3.8859807559686003`*^9}, {3.886061779883998*^9, 
   3.8860618911826696`*^9}, {3.886062270796764*^9, 3.8860623299442167`*^9}, {
   3.88606290416301*^9, 3.88606290438365*^9}, {3.886152279651626*^9, 
   3.8861523073398314`*^9}, {3.8861523706298904`*^9, 
   3.8861523714286704`*^9}, {3.888311253563958*^9, 3.8883112815379667`*^9}, {
   3.8895154757176466`*^9, 3.889515521326418*^9}, 3.889668778999714*^9, {
   3.8896725208785334`*^9, 3.889672555662263*^9}, {3.8896761687511916`*^9, 
   3.8896761875813046`*^9}, {3.8896762430656424`*^9, 3.8896763228575*^9}, {
   3.890203680281665*^9, 3.8902036879233007`*^9}, {3.890203721626855*^9, 
   3.8902037336503353`*^9}, {3.890203765562109*^9, 3.890203784550714*^9}, {
   3.890216653073305*^9, 3.89021672873991*^9}, {3.8902167682576685`*^9, 
   3.890216804044831*^9}, {3.89021744880861*^9, 3.890217482686234*^9}, {
   3.8902177558058324`*^9, 3.890217761492506*^9}, {3.8909816465407667`*^9, 
   3.890981653810565*^9}, {3.8909826260035453`*^9, 3.89098264917115*^9}, {
   3.890982718701262*^9, 3.890982720715917*^9}, {3.891426718226295*^9, 
   3.891426726438856*^9}, {3.8926185908487453`*^9, 3.892618596648994*^9}, {
   3.902367596488429*^9, 3.90236760178779*^9}},
 CellLabel->
  "In[2063]:=",ExpressionUUID->"5cc1674a-6b09-4f41-a48c-1487561a3f0f"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUVnc8lm8Xf7a9Vz8rGSWESKVw35QthEiikFWkVBpSlNEwShIyGkIiyix0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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUWHc81I8bP8fZ4+5kVb6SkZEVlYbOigZKyIqkKJGiUAkZWZW0k1REpEQh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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.003666666666666667], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwUV3c81t8Xt7fs+QwZRalIycyhkoq+KZoyoiIjFEkkFS1klZ2SEZklDdHn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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {-6.487195066484062, -11.512925464970204`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameTicks -> {{{{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           
           TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           
           TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           
           TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100000], -11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50000], -10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 3]], -10.41431317630212], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25000], -10.126631103850338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20000], -9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50000, 3]], -9.721165995742174], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 7]], -9.567015315914915], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[12500], -9.433483923290392], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100000, 9]], -9.315700887634009], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[1000], 6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2000], 7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3000], 8.006367567650246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4000], 8.294049640102028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5000], 8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6000], 8.699514748210191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7000], 8.85366542803745], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8000], 8.987196820661973], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9000], 9.104979856318357], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10000], 9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20000], 9.903487552536127], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30000], 10.308952660644293`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40000], 10.596634733096073`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50000], 10.819778284410283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60000], 11.002099841204238`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70000], 11.156250521031495`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80000], 11.289781913656018`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90000], 11.407564949312402`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100000], 11.512925464970229`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200000], 12.206072645530174`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300000], 12.611537753638338`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400000], 12.89921982609012], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500000], 13.122363377404328`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600000], 13.304684934198283`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700000], 13.458835614025542`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800000], 13.592367006650065`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900000], 13.710150042306449`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}, {{{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Exp[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.487195066484062, 
      1.6310721412512184`}, {-11.512925464970229`, 11.512925464970229`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {0, 0}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], 
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0]}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"31 m\"", "\"10 m\"", "\"1.5 m\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.003666666666666667`", "]"}], 
                   ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.8914267640437527`*^9, 3.892618602412215*^9, 3.8926186799276247`*^9, 
   3.902367646626202*^9},
 CellLabel->
  "Out[2064]=",ExpressionUUID->"c54adce2-141b-46aa-b060-25cccfbd8b48"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C15 - \
1.05\\\\DataSubtracted.pdf\"\>"], "Output",
 CellChangeTimes->{{3.8527879438310833`*^9, 3.852787964921023*^9}, {
   3.8527880302138367`*^9, 3.8527880537745132`*^9}, 3.852788084697062*^9, {
   3.8527881270170593`*^9, 3.852788224333301*^9}, 3.85278831785238*^9, 
   3.852788361683811*^9, {3.852795206034478*^9, 3.852795268644823*^9}, {
   3.852795796660235*^9, 3.852795803347172*^9}, 3.852862499690114*^9, 
   3.853381367103548*^9, 3.853381477275778*^9, 3.8534022418114157`*^9, 
   3.853402534499599*^9, {3.853405270422613*^9, 3.853405324836055*^9}, 
   3.853405407395211*^9, {3.8534097505906153`*^9, 3.8534097703076878`*^9}, 
   3.853410187279647*^9, 3.8534102457215548`*^9, {3.853410571397106*^9, 
   3.853410595830978*^9}, 3.853469096590513*^9, 3.853469303037784*^9, 
   3.853496283640119*^9, 3.8534996296665163`*^9, 3.853817848440113*^9, 
   3.8538182517655993`*^9, 3.853824687596098*^9, 3.85382487471694*^9, 
   3.8538330798017387`*^9, 3.853836456463883*^9, {3.853836638285132*^9, 
   3.853836690462969*^9}, 3.853838543040962*^9, 3.854072558224156*^9, 
   3.854091678576386*^9, 3.8540984652252827`*^9, 3.8544207625736847`*^9, 
   3.854421344558304*^9, {3.8544214059054337`*^9, 3.854421491046699*^9}, 
   3.854423662477191*^9, 3.8601208220618477`*^9, 3.860120994483048*^9, 
   3.86012125099901*^9, 3.860140222318944*^9, 3.8601412086662254`*^9, 
   3.861763743975759*^9, 3.86176383617095*^9, {3.8617640582820826`*^9, 
   3.861764074747286*^9}, 3.8617641740186996`*^9, 3.861764274902935*^9, {
   3.8617643353175488`*^9, 3.861764372253722*^9}, {3.861764623510527*^9, 
   3.8617646348513403`*^9}, 3.8617647132308836`*^9, {3.861767375375707*^9, 
   3.861767457590822*^9}, 3.861941029316691*^9, 3.861950322744031*^9, 
   3.8636862718685603`*^9, 3.8636872310576773`*^9, 3.885975309403617*^9, {
   3.885975375253332*^9, 3.885975398991347*^9}, 3.885976450290474*^9, {
   3.8859766273930984`*^9, 3.885976705321181*^9}, {3.885977079657692*^9, 
   3.8859771107489624`*^9}, 3.885977602788784*^9, {3.885979327503832*^9, 
   3.885979350000666*^9}, {3.8859793893365097`*^9, 3.8859794164248023`*^9}, {
   3.885979462547427*^9, 3.8859794743961115`*^9}, {3.8859797044283705`*^9, 
   3.8859797993350043`*^9}, {3.885979917813003*^9, 3.885979931062524*^9}, {
   3.8859800636906133`*^9, 3.8859800779593983`*^9}, 3.885980312698554*^9, {
   3.8859804016551037`*^9, 3.8859804126591787`*^9}, 3.8859805640552745`*^9, {
   3.885980715872667*^9, 3.8859807602126627`*^9}, {3.8860618090326586`*^9, 
   3.886061895699357*^9}, {3.8860622756094923`*^9, 3.8860623347401624`*^9}, 
   3.8860629092400513`*^9, {3.886152285047185*^9, 3.8861523259663725`*^9}, 
   3.8861523762490544`*^9, 3.888310979206479*^9, {3.888311255213608*^9, 
   3.888311282957345*^9}, 3.8890022856520777`*^9, 3.889060337400128*^9, 
   3.889064570327097*^9, 3.8890819151049967`*^9, 3.889082751667604*^9, 
   3.889084481475959*^9, 3.889504256968684*^9, 3.8895154808895187`*^9, 
   3.8895155265896363`*^9, {3.8896687737857976`*^9, 3.8896687838826714`*^9}, 
   3.8896725629108257`*^9, {3.8896761751473627`*^9, 3.889676192632434*^9}, 
   3.889676249961451*^9, {3.8896763044816694`*^9, 3.8896763296834364`*^9}, {
   3.890203672586771*^9, 3.8902037015966415`*^9}, 3.8902037493461847`*^9, 
   3.8902037965747986`*^9, {3.890216658915124*^9, 3.8902167333765697`*^9}, {
   3.890216774140562*^9, 3.890216809078682*^9}, {3.8902174567679343`*^9, 
   3.8902174874612885`*^9}, 3.890217766852687*^9, 3.8909816129922285`*^9, 
   3.890981659451852*^9, {3.890982631522698*^9, 3.890982655851638*^9}, {
   3.890982726501892*^9, 3.8909827519660463`*^9}, 3.891416093072353*^9, 
   3.8914267640437527`*^9, 3.892618602412215*^9, 3.8926186799276247`*^9, 
   3.9023676512265053`*^9},
 CellLabel->
  "Out[2065]=",ExpressionUUID->"b1b87ddd-3412-457e-b334-850ce9bf0558"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Merge", " ", 
    RowBox[{"(", "relevant", ")"}], " ", "patterns"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Usually", " ", "we", " ", "only", " ", "merge", " ", "pattern", " ", "2",
      " ", "and", " ", "3"}], ",", " ", 
    RowBox[{
    "but", " ", "sometimes", " ", "we", " ", "also", " ", "use", " ", "1", 
     " ", "when", " ", "2", " ", "contains", " ", "a", " ", "weird", " ", 
     "kink", " ", "or", " ", "noise", " ", "etc"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "2", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"only", " ", "pattern", " ", "1", " ", "and", " ", "3"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.1"}], "&"}]}], "]"}], ",",
        " ", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{"default", ":", " ", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], " ", 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.06", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "2"}], "&"}]}], "]"}]}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"default", ":", " ", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Sequential", " ", "merging", " ", "of", " ", "first", " ", "pattern", 
     " ", "1"}], " ", "+", " ", 
    RowBox[{"2", " ", "and", " ", "then", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "2"}], ")"}]}], " ", "+", " ", "3"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"datamerged1", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.004", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.005", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], " ", 
       RowBox[{"(*", " ", 
        RowBox[{"0.02", "<", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "<", "0.2"}], " ", "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "2", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.1", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamerged", "=", 
     RowBox[{"mergeData", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{"datamerged1", ",", 
         RowBox[{
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.3"}], "&"}]}], "]"}], ",", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{"default", ":", 
          RowBox[{"0", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.5"}]}], "&"}], "*)"}], 
       "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"dataToAnalyze", "[", 
          RowBox[{"[", "3", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"0.05", "<", 
           RowBox[{"#", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "<", "0.4"}], "&"}]}], "]"}]}], 
      " ", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"default", ":", 
         RowBox[{"0.2", "<", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "<", "2"}]}], "&"}], "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "1"}], " ", "*)"}], " ", 
      RowBox[{"(*", " ", 
       RowBox[{"0.05", "<", 
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "<", "0.7"}], " ", "*)"}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
    RowBox[{"datamerged1", ",", "\[IndentingNewLine]", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", 
          RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",", 
     " ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
       " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
       "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", " ", "->", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
       "}"}]}]}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plotDataMerged", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamerged", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMerged.pdf\>\""}], "}"}], "]"}], ",", "plotDataMerged"}], 
    " ", "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Bin", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datamergedbinned", "=", 
     RowBox[{"binData", "[", 
      RowBox[{"datamerged", ",", "0.05"}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"default", ":", " ", "0.05"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plotDataBinned", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", "\[IndentingNewLine]", 
     RowBox[{"datamergedbinned", ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<DataMergedBinned.pdf\>\""}], "}"}], "]"}], ",", 
     "plotDataBinned"}], " ", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Export", " ", "merged", " ", "and", " ", "binned", " ", "data", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", "datamergedbinned", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS data merged and binned.csv\>\""}]}], 
       "\[IndentingNewLine]", "}"}], "\[IndentingNewLine]", "]"}], ",", 
     "\[IndentingNewLine]", "exportlist"}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.854423668689094*^9, 3.854423681960602*^9}, {
   3.8601210812169123`*^9, 3.8601211773702602`*^9}, {3.860121220142*^9, 
   3.860121220876803*^9}, {3.860121492525386*^9, 3.8601215079101877`*^9}, {
   3.860121718604267*^9, 3.8601217659879427`*^9}, {3.860121814486486*^9, 
   3.860121940090294*^9}, {3.860121990307417*^9, 3.860122029773138*^9}, {
   3.86012227550008*^9, 3.860122412026474*^9}, {3.860123590194846*^9, 
   3.8601236144362907`*^9}, 3.8601236508219957`*^9, {3.860139958454444*^9, 
   3.8601400142502003`*^9}, {3.8601409041122975`*^9, 
   3.8601409737863803`*^9}, {3.860141247131112*^9, 3.8601412486662936`*^9}, 
   3.860141363728487*^9, {3.861764464753133*^9, 3.8617644999883156`*^9}, {
   3.8617650690038815`*^9, 3.861765107161731*^9}, {3.8617654080879517`*^9, 
   3.8617654464808097`*^9}, {3.8617667857822647`*^9, 3.861766817572381*^9}, {
   3.861767478263466*^9, 3.8617674824174633`*^9}, {3.8617675156782837`*^9, 
   3.8617675385223627`*^9}, {3.861767600750394*^9, 3.8617678801582737`*^9}, {
   3.861768004639906*^9, 3.861768004842128*^9}, {3.8617680471976347`*^9, 
   3.8617680542883253`*^9}, 3.8617682512241673`*^9, {3.8619408859545107`*^9, 
   3.8619408879723635`*^9}, 3.8619500601432023`*^9, {3.8859755937637935`*^9, 
   3.8859756289602833`*^9}, {3.8859767824682684`*^9, 
   3.8859768072202587`*^9}, {3.885976912247283*^9, 3.885976915489427*^9}, {
   3.885977184321333*^9, 3.8859771875417037`*^9}, {3.8859772431391516`*^9, 
   3.8859772459190493`*^9}, {3.8859776946505795`*^9, 3.885977697414628*^9}, {
   3.885977754450777*^9, 3.8859777568929634`*^9}, {3.8859804425147095`*^9, 
   3.8859804438235583`*^9}, 3.8859804753994827`*^9, {3.8859807731997614`*^9, 
   3.885980782688805*^9}, 3.8860629984459877`*^9, {3.886063060466019*^9, 
   3.8860631273919067`*^9}, {3.886071125028043*^9, 3.8860711896934166`*^9}, {
   3.8860714254613867`*^9, 3.8860714550837*^9}, {3.8895154616447597`*^9, 
   3.8895154658794193`*^9}, {3.8896724114246473`*^9, 3.889672412507053*^9}, {
   3.889672471225835*^9, 3.8896725071452694`*^9}, {3.889674589350315*^9, 
   3.889674633174043*^9}, {3.889674670910601*^9, 3.889674765787591*^9}, {
   3.8896748131059356`*^9, 3.889674848516157*^9}, {3.8896748918371353`*^9, 
   3.8896749698660383`*^9}, {3.8896759808235216`*^9, 
   3.8896760211101522`*^9}, {3.8896760618397036`*^9, 3.889676134804789*^9}, {
   3.8896766120107994`*^9, 3.8896766124494815`*^9}, {3.889676755304323*^9, 
   3.889676755581999*^9}, {3.8902038545244083`*^9, 3.890203901273981*^9}, {
   3.890205930477414*^9, 3.8902059314228735`*^9}, {3.8902102550185256`*^9, 
   3.890210255342898*^9}, 3.8902167482021494`*^9, {3.8902168284956217`*^9, 
   3.89021682871568*^9}, {3.890216868216955*^9, 3.8902168763206763`*^9}, {
   3.8902172079856234`*^9, 3.8902172082346754`*^9}, {3.890981726002406*^9, 
   3.890981786213588*^9}, {3.8909822356137176`*^9, 3.8909822357713594`*^9}, {
   3.891426796114186*^9, 3.8914267996467695`*^9}, {3.8926189112287703`*^9, 
   3.8926189114608297`*^9}, {3.902367607302034*^9, 3.902367608193674*^9}, {
   3.9023726000357075`*^9, 3.902372600426222*^9}},
 CellLabel->
  "In[2123]:=",ExpressionUUID->"5b3c3b75-f6f9-43b4-ae93-bf843c1633be"],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 2124, 148, 17025713724928210084, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.90236765255013*^9, 3.9023726014387875`*^9},
 CellLabel->
  "During evaluation of \
In[2123]:=",ExpressionUUID->"33113bc0-7317-464a-aeff-04483a3aeb7c"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.004583333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwUWXc8lf8Xv3vYM31DoUiRTSk8D5nZFEmUlJVSlKaiSIsiCSkpqUQpQtbn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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.70445447981363, -5.760799061201112},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->FrontEndValueCache[{{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {
      Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
       15.954589770191003`, RotateLabel -> 0], {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}, {{{{-6.907755278982137, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{"10", 
           RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
         TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {2.302585092994046, 
        FormBox[
         TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {4.605170185988092, 
        FormBox[
         TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {6.907755278982137, 
        FormBox[
         TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> 
          SuperscriptBox], TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.4011973816621555`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.6888794541139363`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.0943445622221, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.248495242049359, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.382026634673881, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.499809670330265, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.703782474656201, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {5.991464547107982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.396929655216146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.551080335043404, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.684611727667927, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.802394763324311, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {7.600902459542082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.006367567650246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.294049640102028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.517193191416238, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.699514748210191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.85366542803745, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {8.987196820661973, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {9.104979856318357, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}, {{{-5.298317366548036, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.005\"", ShowStringCharacters -> False], 
           0.005`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-4.605170185988091, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.010\"", ShowStringCharacters -> False], 
           0.01`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.995732273553991, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.050\"", ShowStringCharacters -> False], 
           0.05`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-2.3025850929940455`, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.100\"", ShowStringCharacters -> False], 
           0.1`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-0.6931471805599453, 
        FormBox[
         TagBox[
          InterpretationBox[
           StyleBox["\"0.500\"", ShowStringCharacters -> False], 
           0.5`15.954589770191003, AutoDelete -> True], NumberForm[#, {
            DirectedInfinity[1], 3}]& ], TraditionalForm], {0.01, 
        0.}}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-2.4079456086518722`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.916290731874155, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.35667494393873245`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.2231435513142097, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}, {-0.10536051565782628`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {0., 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
        0.}}}, {{-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], 
         TraditionalForm]}, {-6.907755278982137, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-6.214608098422191, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.809142990314028, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.521460917862246, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.298317366548036, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-5.115995809754082, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.961845129926823, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.8283137373023015`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.710530701645918, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-4.605170185988092, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.912023005428146, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.506557897319982, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-3.2188758248682006`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.995732273553991, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.8134107167600364`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.659260036932778, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.5257286443082556`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.407945608651872, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-2.302585092994046, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-1.2039728043259361`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.9162907318741551, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.5108256237659907, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.3566749439387324, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.22314355131420976`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {-0.10536051565782635`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {0.6931471805599453, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.0986122886681098`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.3862943611198906`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.6094379124341003`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.791759469228055, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {1.9459101490553132`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.0794415416798357`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}, {2.1972245773362196`, 
        FormBox[
         TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
         Thickness[0.001]}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.70445447981363, -0.6940203524770587}, {-5.760799061201112, 
   5.509944150675044}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.9023676535337334`*^9, 3.902372601615986*^9},
 CellLabel->
  "Out[2125]=",ExpressionUUID->"2f09be1b-7a62-48d1-9005-e345c4005cc1"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwVV3k41d/XdU13didDv1IpNHwVopSoc4hMRSGSmVRKElJSkiINMmSIBhqV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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.694900859427885, -4.978354944840276},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.694900859427885, -0.920943459371443}, {-4.978354944840276, 
   5.509944150675044}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.9023676535337334`*^9, 3.902372601989193*^9},
 CellLabel->
  "Out[2126]=",ExpressionUUID->"6b5247e9-2f20-45e8-a785-c515e3786b21"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C15 - \
1.05\\\\DataMerged.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.9023676535337334`*^9, 3.9023726029650283`*^9},
 CellLabel->
  "Out[2127]=",ExpressionUUID->"f772d1f9-05f2-445f-a6f1-95992cb89bd3"],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.483842181677217, 5.417837514274544}, {-5.483842181677217,
          5.464425104439405}}], 
        LineBox[{{-5.483842181677217, 5.464425104439405}, {-5.483842181677217,
          5.508938561506401}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.380228407219979, 
         5.3225930518109035`}, {-5.380228407219979, 5.333630880724602}}], 
        LineBox[{{-5.380228407219979, 5.333630880724602}, {-5.380228407219979,
          5.344548204872068}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.286352047426554, 5.206400183548847}, {-5.286352047426554,
          5.219882294260513}}], 
        LineBox[{{-5.286352047426554, 5.219882294260513}, {-5.286352047426554,
          5.233185053025214}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.228332740694611, 5.176319154330323}, {-5.228332740694611,
          5.184592115885053}}], 
        LineBox[{{-5.228332740694611, 5.184592115885053}, {-5.228332740694611,
          5.192797196737359}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.1734965151745005`, 
         5.110132688625956}, {-5.1734965151745005`, 5.137053569635874}}], 
        LineBox[{{-5.1734965151745005`, 
         5.137053569635874}, {-5.1734965151745005`, 5.16326867539695}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.121512103387059, 5.046460606160277}, {-5.121512103387059,
          5.063617291563528}}], 
        LineBox[{{-5.121512103387059, 5.063617291563528}, {-5.121512103387059,
          5.0804845831722485`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.0720974097604925`, 
         4.959181185941672}, {-5.0720974097604925`, 4.976886806119893}}], 
        LineBox[{{-5.0720974097604925`, 
         4.976886806119893}, {-5.0720974097604925`, 4.994284383493903}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-5.025010372042255, 4.877619299771134}, {-5.025010372042255,
          4.891975729411344}}], 
        LineBox[{{-5.025010372042255, 4.891975729411344}, {-5.025010372042255,
          4.906128965670482}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.980041374477484, 4.786700683245617}, {-4.980041374477484,
          4.814503845152611}}], 
        LineBox[{{-4.980041374477484, 4.814503845152611}, {-4.980041374477484,
          4.841554856278032}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.92662358321994, 4.715462383418227}, {-4.92662358321994, 
         4.737819366249398}}], 
        LineBox[{{-4.92662358321994, 4.737819366249398}, {-4.92662358321994, 
         4.759687425339699}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.87574337247038, 4.630913774365157}, {-4.87574337247038, 
         4.653976487107258}}], 
        LineBox[{{-4.87574337247038, 4.653976487107258}, {-4.87574337247038, 
         4.676519279381845}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.827483513108963, 
         4.5000768159234275`}, {-4.827483513108963, 4.537692654679549}}], 
        LineBox[{{-4.827483513108963, 4.537692654679549}, {-4.827483513108963,
          4.573944687833027}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.77239942676781, 4.449335571203944}, {-4.77239942676781, 
         4.4695674831794925`}}], 
        LineBox[{{-4.77239942676781, 4.4695674831794925`}, {-4.77239942676781,
          4.48939816904962}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.720192452293243, 4.352695960160602}, {-4.720192452293243,
          4.368286715931976}}], 
        LineBox[{{-4.720192452293243, 4.368286715931976}, {-4.720192452293243,
          4.38363812683159}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.670576785004793, 4.23722347043888}, {-4.670576785004793, 
         4.256989991356286}}], 
        LineBox[{{-4.670576785004793, 4.256989991356286}, {-4.670576785004793,
          4.276373358312023}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.623307322213241, 4.170494438096535}, {-4.623307322213241,
          4.190556355312096}}], 
        LineBox[{{-4.623307322213241, 4.190556355312096}, {-4.623307322213241,
          4.2102236950131235`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.578172095309458, 4.093944785141605}, {-4.578172095309458,
          4.11358571000768}}], 
        LineBox[{{-4.578172095309458, 4.11358571000768}, {-4.578172095309458, 
         4.13284828809653}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.528024063416046, 3.991961225242301}, {-4.528024063416046,
          4.015987305113403}}], 
        LineBox[{{-4.528024063416046, 4.015987305113403}, {-4.528024063416046,
          4.039449650323451}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.473567500947851, 
         3.8960611887669825`}, {-4.473567500947851, 3.9181807203033525`}}], 
        LineBox[{{-4.473567500947851, 
         3.9181807203033525`}, {-4.473567500947851, 3.9398215477786636`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.4219245540939545`, 
         3.8228570574236875`}, {-4.4219245540939545`, 3.839083039583799}}], 
        LineBox[{{-4.4219245540939545`, 
         3.839083039583799}, {-4.4219245540939545`, 3.8550499375488516`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.372818566555532, 
         3.7244599448592295`}, {-4.372818566555532, 3.740220787357705}}], 
        LineBox[{{-4.372818566555532, 3.740220787357705}, {-4.372818566555532,
          3.755737075105077}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.326011954933506, 3.642353947140639}, {-4.326011954933506,
          3.6531535519137917`}}], 
        LineBox[{{-4.326011954933506, 
         3.6531535519137917`}, {-4.326011954933506, 3.6638377702422016`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.275892138786888, 3.541522917327234}, {-4.275892138786888,
          3.554734859295386}}], 
        LineBox[{{-4.275892138786888, 3.554734859295386}, {-4.275892138786888,
          3.5677745195555377`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.222951251037713, 3.463020220355893}, {-4.222951251037713,
          3.4746322834901897`}}], 
        LineBox[{{-4.222951251037713, 
         3.4746322834901897`}, {-4.222951251037713, 3.4861110529482615`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.172673294218139, 
         3.3625658738797313`}, {-4.172673294218139, 3.3721568093433505`}}], 
        LineBox[{{-4.172673294218139, 
         3.3721568093433505`}, {-4.172673294218139, 3.3816566319298387`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.124803134014643, 
         3.2435448320260485`}, {-4.124803134014643, 3.2643138037145327`}}], 
        LineBox[{{-4.124803134014643, 
         3.2643138037145327`}, {-4.124803134014643, 3.284660187062398}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.074701219535939, 3.158216940703002}, {-4.074701219535939,
          3.166981562982009}}], 
        LineBox[{{-4.074701219535939, 3.166981562982009}, {-4.074701219535939,
          3.1756700336144883`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-4.026921534839552, 
         3.0486649540172106`}, {-4.026921534839552, 3.0649675042920754`}}], 
        LineBox[{{-4.026921534839552, 
         3.0649675042920754`}, {-4.026921534839552, 3.081008539091662}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.9773780413268547`, 
         2.9710960394935824`}, {-3.9773780413268547`, 2.987510993021455}}], 
        LineBox[{{-3.9773780413268547`, 
         2.987510993021455}, {-3.9773780413268547`, 3.0036608416776454`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.9262371908045295`, 
         2.8546951380761514`}, {-3.9262371908045295`, 2.8691575089271093`}}], 
        LineBox[{{-3.9262371908045295`, 
         2.8691575089271093`}, {-3.9262371908045295`, 2.883413697943115}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.8776461425773476`, 
         2.7685940148375114`}, {-3.8776461425773476`, 2.783931135735293}}], 
        LineBox[{{-3.8776461425773476`, 
         2.783931135735293}, {-3.8776461425773476`, 2.799036578163567}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.827799486652153, 
         2.6626022260682256`}, {-3.827799486652153, 2.6772943789938246`}}], 
        LineBox[{{-3.827799486652153, 
         2.6772943789938246`}, {-3.827799486652153, 2.691773794363211}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.7770410262852683`, 
         2.534232817714081}, {-3.7770410262852683`, 2.541536060877438}}], 
        LineBox[{{-3.7770410262852683`, 
         2.541536060877438}, {-3.7770410262852683`, 2.548786353159605}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.7255676492705025`, 
         2.4155372235346264`}, {-3.7255676492705025`, 2.4317636809870544`}}], 
        LineBox[{{-3.7255676492705025`, 
         2.4317636809870544`}, {-3.7255676492705025`, 2.4477310391868503`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.6766150586043187`, 
         2.3141683223556906`}, {-3.6766150586043187`, 2.3268988240712045`}}], 
        LineBox[{{-3.6766150586043187`, 
         2.3268988240712045`}, {-3.6766150586043187`, 2.3394692952477385`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.6271250750319357`, 
         2.2026825144064497`}, {-3.6271250750319357`, 2.2114826220324577`}}], 
        LineBox[{{-3.6271250750319357`, 
         2.2114826220324577`}, {-3.6271250750319357`, 2.220205962829503}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.577239779380398, 2.138351611837451}, {-3.577239779380398,
          2.1497141483636133`}}], 
        LineBox[{{-3.577239779380398, 
         2.1497141483636133`}, {-3.577239779380398, 2.1609490268149796`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.5271719803333474`, 
         2.022387310492095}, {-3.5271719803333474`, 2.0319065570228574`}}], 
        LineBox[{{-3.5271719803333474`, 
         2.0319065570228574`}, {-3.5271719803333474`, 2.0413360412967285`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.4770227859145613`, 
         1.9071914228403979`}, {-3.4770227859145613`, 1.9199765243853684`}}], 
        LineBox[{{-3.4770227859145613`, 
         1.9199765243853684`}, {-3.4770227859145613`, 1.9326002284216452`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.4269594457071775`, 
         1.80580904315492}, {-3.4269594457071775`, 1.8161269829780138`}}], 
        LineBox[{{-3.4269594457071775`, 
         1.8161269829780138`}, {-3.4269594457071775`, 1.8263395492317758`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.377049578478242, 
         1.6982468217302742`}, {-3.377049578478242, 1.7118291870599704`}}], 
        LineBox[{{-3.377049578478242, 
         1.7118291870599704`}, {-3.377049578478242, 1.7252295411246055`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.327422124402821, 1.588807928802749}, {-3.327422124402821,
          1.6019626233883113`}}], 
        LineBox[{{-3.327422124402821, 
         1.6019626233883113`}, {-3.327422124402821, 1.6149465163957857`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.2761327623308096`, 
         1.508819876909052}, {-3.2761327623308096`, 1.5156779530897848`}}], 
        LineBox[{{-3.2761327623308096`, 
         1.5156779530897848`}, {-3.2761327623308096`, 1.5224893162412891`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.2254264836890396`, 
         1.374259465336078}, {-3.2254264836890396`, 1.3879756042382896`}}], 
        LineBox[{{-3.2254264836890396`, 
         1.3879756042382896`}, {-3.2254264836890396`, 1.4015061533788404`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.17716826024446, 1.2839962928198143`}, {-3.17716826024446,
          1.293378448134219}}], 
        LineBox[{{-3.17716826024446, 1.293378448134219}, {-3.17716826024446, 
         1.3026733961687724`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.127705210497175, 1.185281368634678}, {-3.127705210497175,
          1.1978363311896516`}}], 
        LineBox[{{-3.127705210497175, 
         1.1978363311896516`}, {-3.127705210497175, 1.2102356191293275`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.077261733718196, 
         1.0767785214228451`}, {-3.077261733718196, 1.0867374837788857`}}], 
        LineBox[{{-3.077261733718196, 
         1.0867374837788857`}, {-3.077261733718196, 1.0965982424072902`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-3.0276924518494375`, 
         0.9729319658086968}, {-3.0276924518494375`, 0.9850537525105203}}], 
        LineBox[{{-3.0276924518494375`, 
         0.9850537525105203}, {-3.0276924518494375`, 0.997030359579647}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.977298040136891, 
         0.8562551208123013}, {-2.977298040136891, 0.8683465073199272}}], 
        LineBox[{{-2.977298040136891, 
         0.8683465073199272}, {-2.977298040136891, 0.8802934371425442}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.932588839908245, 
         0.7611259976512463}, {-2.932588839908245, 0.7694025329536415}}], 
        LineBox[{{-2.932588839908245, 
         0.7694025329536415}, {-2.932588839908245, 0.7776111291353157}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.522480231534296, -0.13413734489922288`}, \
{-2.522480231534296, -0.09076332003771556}}], 
        LineBox[{{-2.522480231534296, -0.09076332003771556}, \
{-2.522480231534296, -0.04919265325399851}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.380038563220422, -0.4467421447418757}, \
{-2.380038563220422, -0.4078317670824148}}], 
        LineBox[{{-2.380038563220422, -0.4078317670824148}, \
{-2.380038563220422, -0.3703788726758086}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.2851211182798545`, -0.6621158919413321}, \
{-2.2851211182798545`, -0.6274646867398472}}], 
        LineBox[{{-2.2851211182798545`, -0.6274646867398472}, \
{-2.2851211182798545`, -0.5939740835347245}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.226506167649257, -0.7950549331318056}, \
{-2.226506167649257, -0.7616916242351741}}], 
        LineBox[{{-2.226506167649257, -0.7616916242351741}, \
{-2.226506167649257, -0.729405581258037}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.1711381157832257`, -0.9224118791351459}, \
{-2.1711381157832257`, -0.8901233009952789}}], 
        LineBox[{{-2.1711381157832257`, -0.8901233009952789}, \
{-2.1711381157832257`, -0.8588447478634074}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.1186760185140363`, -1.046272347457581}, \
{-2.1186760185140363`, -1.0142652637280023`}}], 
        LineBox[{{-2.1186760185140363`, -1.0142652637280023`}, \
{-2.1186760185140363`, -0.9832509401695667}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.0688299492905053`, -1.1636489299954833`}, \
{-2.0688299492905053`, -1.1343184641208914`}}], 
        LineBox[{{-2.0688299492905053`, -1.1343184641208914`}, \
{-2.0688299492905053`, -1.105823817710152}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-2.021351319690928, -1.2750086650219452`}, \
{-2.021351319690928, -1.246794574841844}}], 
        LineBox[{{-2.021351319690928, -1.246794574841844}, \
{-2.021351319690928, -1.219354725008327}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.976025406568619, -1.3819327176281513`}, \
{-1.976025406568619, -1.3554601062395841`}}], 
        LineBox[{{-1.976025406568619, -1.3554601062395841`}, \
{-1.976025406568619, -1.3296702583164817`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.9326653384575119`, -1.4841290625854302`}, \
{-1.9326653384575119`, -1.4578141772959292`}}], 
        LineBox[{{-1.9326653384575119`, -1.4578141772959292`}, \
{-1.9326653384575119`, -1.432174047030941}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.8810672419769725`, -1.6123365397642875`}, \
{-1.8810672419769725`, -1.5835618345718234`}}], 
        LineBox[{{-1.8810672419769725`, -1.5835618345718234`}, \
{-1.8810672419769725`, -1.5555920069046263`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.8223707416388202`, -1.75597188625365}, \
{-1.8223707416388202`, -1.7282825872153513`}}], 
        LineBox[{{-1.8223707416388202`, -1.7282825872153513`}, \
{-1.8223707416388202`, -1.7013393732674091`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.7758907745205157`, -1.8683524999423151`}, \
{-1.7758907745205157`, -1.8452209669377861`}}], 
        LineBox[{{-1.7758907745205157`, -1.8452209669377861`}, \
{-1.7758907745205157`, -1.8226124269148638`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.7316070609965282`, -1.9813116473451888`}, \
{-1.7316070609965282`, -1.9555608991960096`}}], 
        LineBox[{{-1.7316070609965282`, -1.9555608991960096`}, \
{-1.7316070609965282`, -1.9304566393456335`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.680857774871063, -2.109714978568611}, \
{-1.680857774871063, -2.084853691113118}}], 
        LineBox[{{-1.680857774871063, -2.084853691113118}, \
{-1.680857774871063, -2.06059552325229}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.632560487956873, -2.231357849525613}, \
{-1.632560487956873, -2.207643969125207}}], 
        LineBox[{{-1.632560487956873, -2.207643969125207}, \
{-1.632560487956873, -2.184479434866337}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.5790774413137347`, -2.374220223675227}, \
{-1.5790774413137347`, -2.3487857021387883`}}], 
        LineBox[{{-1.5790774413137347`, -2.3487857021387883`}, \
{-1.5790774413137347`, -2.3239820819803727`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.5281875999704038`, -2.504139578060469}, \
{-1.5281875999704038`, -2.483030853564537}}], 
        LineBox[{{-1.5281875999704038`, -2.483030853564537}, \
{-1.5281875999704038`, -2.4623585117058133`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4798745637368198`, -2.6364093686589083`}, \
{-1.4798745637368198`, -2.612812183844095}}], 
        LineBox[{{-1.4798745637368198`, -2.612812183844095}, \
{-1.4798745637368198`, -2.589759013608759}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.4273150021222818`, -2.7770452296855144`}, \
{-1.4273150021222818`, -2.753986856046442}}], 
        LineBox[{{-1.4273150021222818`, -2.753986856046442}, \
{-1.4273150021222818`, -2.7314482094500323`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.377381030775886, -2.9114797730071222`}, \
{-1.377381030775886, -2.8895155519621367`}}], 
        LineBox[{{-1.377381030775886, -2.8895155519621367`}, \
{-1.377381030775886, -2.868023407694775}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.329822772449285, -3.0435512808981082`}, \
{-1.329822772449285, -3.0222439174980185`}}], 
        LineBox[{{-1.329822772449285, -3.0222439174980185`}, \
{-1.329822772449285, -3.001381102153626}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.2789374525299622`, -3.188598468348998}, \
{-1.2789374525299622`, -3.1657500104431104`}}], 
        LineBox[{{-1.2789374525299622`, -3.1657500104431104`}, \
{-1.2789374525299622`, -3.143411964156037}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.2252283792125176`, -3.3406566640892486`}, \
{-1.2252283792125176`, -3.319232093082962}}], 
        LineBox[{{-1.2252283792125176`, -3.319232093082962}, \
{-1.2252283792125176`, -3.2982569229281125`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.1742581157840541`, -3.48732431828529}, \
{-1.1742581157840541`, -3.4672107545015907`}}], 
        LineBox[{{-1.1742581157840541`, -3.4672107545015907`}, \
{-1.1742581157840541`, -3.4474937824002603`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.125760810882863, -3.6256515647545937`}, \
{-1.125760810882863, -3.606348565790899}}], 
        LineBox[{{-1.125760810882863, -3.606348565790899}, \
{-1.125760810882863, -3.5874111273180835`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.0750347908756233`, -3.7788249036850137`}, \
{-1.0750347908756233`, -3.757787844084705}}], 
        LineBox[{{-1.0750347908756233`, -3.757787844084705}, \
{-1.0750347908756233`, -3.7371842394001518`}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-1.026687762897248, -3.9237496337754716`}, \
{-1.026687762897248, -3.9045557583567705`}}], 
        LineBox[{{-1.026687762897248, -3.9045557583567705`}, \
{-1.026687762897248, -3.885723360524215}}]}},
      Antialiasing->False]}, 
    {RGBColor[0.368417, 0.506779, 0.709798], 
     StyleBox[{{}, {
        LineBox[{{-0.9765855081311018, -4.072672889894351}, \
{-0.9765855081311018, -4.053386555977001}}], 
        LineBox[{{-0.9765855081311018, -4.053386555977001}, \
{-0.9765855081311018, -4.034465157565224}}]}},
      Antialiasing->False]}}, 
   {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.011000000000000001`], 
    AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwV0H8803kcwPGZbWY2+31FxLpIi+sHKdf0/cgoV4oyuoooComKSl2UCl2J
uEoq63ElkawkP0r6vBP9EqFSKE1GosKGiei6P16P5/8v0YaIlUFkEom09mf/
G9EtXhXVK4RGurVTWosQbVtPLVKWCmGQSJgqUQjRLkH0mTXxQghM3yS7JBOi
4rRdSN9LCK5pAbGaaUL0Zu25aAcLIYy7jDZYtQkQJL82rPskgBPutiXUcgHq
/ofByy0QQPAx3yqfJAHy3TU/b+s+AbztFKumOglQ1SzpxxduAjAvqdOVdfFR
85crnueNBEBO7xZuSOUjabiHNqWHD5LTVUtZi/jIIpFW9/YWH0Sn43oSNDxU
W93WWnGAD+bdIt1rmTw0aH6s0WcFHy6lSz6eseShjqtCZe8vfIgS+i1rVHJR
WaFMtLeNBye7RdPM93BR3lypIk/Bg+lGARus9LgonuXpKo3lAXv7ETvRAw6K
dDq0munBgyRj7fMVURzUGcP2uWnCg8HID9/8OBzUx6e0fVVxQSK2nhKxmo30
mg+PMW9wYYq5zYztxYZozdO9lpUxXAgTL1MO97DQARs1v9GdC67tVak5DixU
gKjRh4y5oPgR9XLiNia6IZkpc1dxoOjObTLzmQH6LJFL629wwLEr+E+bEQZS
myUFPtvPgRyFfbKHKQOhQ6N7YpdxIMKHFD4i00c5D+WeqZM4UN1Rr2DF01G0
3PhkXj0bSspbpod16iHn+94GvcFsiPA0a6YP0JB/1kKfLVQ21Aaqr8e40JDf
EW9v2QVDWLL6rofRFiqa7WviFjDPEBinS1s4MgoSzQ8KGaphAS9+6WEUpYuW
x3ZMKwphwW1VpCgmk4wEJvcs11BYMBDCqDEt0EG1JoXtM+VMGK947ZU5RweV
zd7df3keE7YlpjusdiKhpRmJK/vrDCBT/MrdoXScKFwIxSGhBmAZ8FLcYjhG
9LpWps6hGMAm6zDSlY2jhLX/xZgUOQM63runXPr3G2EY/31C/FwGmF3YlzAP
DRPMh9GbrtXow63Tjl0Wc4cIPVPf2a9D9WHB5riM/IIBovaT3YqjVH1g3X64
1VusITxD121aIKfDNQX5jevGfiLPY7i+eD4d/Iv37kiJ7yVycxMuxtXrAWmy
Z2bskx5ieDr6tX+nHuDmFLZa3kVYZCT4uXygwQvBqYnQoCKyhmebSnbToG78
MZcsbSNk+2bxDnNpsNDfT20W20Ls17sYfv4GFRyyA5SqLy+JAH/7KqEXFeJa
14WkTKwhZn55MjVllALvZ3Sc4imBsE7/I7MwmwKTvgsPPtZkEduHM0wZv1Gg
lur4wllSgjtrmxZsKNOFXHH83rL0auzC6zuavkMXlgzRlqqaGrCJzsEcT4Yu
GLVHh3QbNePqDOmzlGwyuPT0nz9brsRpboUnvywmw5zp8oZZAhW+Jbbd/eG5
Dli7aE0ere/COcb83Bg/HVj2Kuht+1+f8b2baSFMDQny29Psw3/vwxZxISVD
SSTo8xNPnmGpxssD5Y53ZpDAJVTS2qrW4E8RgvpnmT9w1vKi3qHrg7jybFjM
nM/j2NFox6DdKi0ObH831DRxHC9Qinul3t9wTCjdIdxqDAsDgrIMroziPu93
25mh33HpIsUWWsIY9jKgn8u9NYovi4odRtx+4DcPpWbVqhFcYHex6lE+CZTO
dKydPIKfv6p0dMrVgfOFlKJO52+4+/t+K4+nZOgJRq+jIoexrWXpYuLdzy+f
vDUn8rV4wjkdPuMjBWzdIp2WNA7hnKsVi8R0GrSShQWgP4Szr2/2umOqB11e
KxcOuA5i1UHu/GQbOhz/6jw5cdcATvKsL49apQ/tJ/N5f5/V4M4fkuQnxxmw
W1GlrHiixiMbtWNv7hpA/4PMSlNdNbbaqHStaWJCndZd4WPbjw/blvM0bEPI
Pl5j4bG1DxsG372TKGHD/Z1BaBbqxQdbzbRX7TnwHzSSvqU=
     "]]}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.673600817672854, -4.822488361897626},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{"10", "3"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[1000], 6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2000], 7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3000], 8.006367567650246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4000], 8.294049640102028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5000], 8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6000], 8.699514748210191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7000], 8.85366542803745], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8000], 8.987196820661973], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9000], 9.104979856318357], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.673600817672854, -0.9765855081311018}, {-4.822488361897626, 
   5.508938561506401}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.9023676535337334`*^9, 3.9023726033463674`*^9},
 CellLabel->
  "Out[2129]=",ExpressionUUID->"09fa764d-ef0c-4593-adfe-3f3e9416c672"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C15 - \
1.05\\\\DataMergedBinned.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.9023676535337334`*^9, 3.9023726040828238`*^9},
 CellLabel->
  "Out[2130]=",ExpressionUUID->"e0cd9f76-d380-41e2-8e97-81c721f87de1"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C15 - 1.05\\\\Sample \
playground LH-ESRF-C15 NEW SAXS data merged and binned.csv\"\>"], "Output",
 CellChangeTimes->{
  3.860121940449121*^9, {3.8601219909814587`*^9, 3.8601219988911247`*^9}, 
   3.8601220305416183`*^9, {3.860122288162386*^9, 3.860122319486766*^9}, {
   3.860122357383444*^9, 3.860122415048162*^9}, 3.8601236448414707`*^9, 
   3.860123678830523*^9, 3.8601409845329585`*^9, 3.8601412163576555`*^9, 
   3.8601413747528563`*^9, 3.86176442550534*^9, 3.861764508178524*^9, 
   3.861764647876793*^9, 3.8617647988763914`*^9, {3.8617650704595146`*^9, 
   3.8617651079871264`*^9}, 3.861765409439147*^9, 3.8617654499851933`*^9, {
   3.861766787669303*^9, 3.8617668184387875`*^9}, {3.861767630673935*^9, 
   3.861767650165983*^9}, 3.861767840576668*^9, {3.8617678717452784`*^9, 
   3.8617678816675997`*^9}, 3.8617680171083403`*^9, {3.8617680479968414`*^9, 
   3.8617680548824015`*^9}, 3.8617682519250493`*^9, 3.861941029901291*^9, 
   3.8619500639728465`*^9, 3.861950323504904*^9, 3.863686272586315*^9, 
   3.8636872317935305`*^9, 3.885975634223706*^9, 3.885976810854197*^9, 
   3.885976922495121*^9, 3.8859771898386564`*^9, 3.885977254405377*^9, 
   3.8859776985071163`*^9, 3.8859777591377735`*^9, 3.8859795032705593`*^9, 
   3.885980141889553*^9, 3.8859804453711944`*^9, 3.8859806226937556`*^9, 
   3.8859807856447215`*^9, {3.8860631041737103`*^9, 3.886063131011697*^9}, {
   3.8860711788656583`*^9, 3.8860711903529096`*^9}, 3.8860714565699263`*^9, {
   3.886152356693725*^9, 3.886152379601023*^9}, 3.888310979615314*^9, 
   3.888311304522476*^9, 3.889002297204956*^9, 3.889060341097105*^9, 
   3.88906457053371*^9, 3.889081915278277*^9, 3.889082751832595*^9, 
   3.8890844816819963`*^9, 3.8895042732162266`*^9, 3.8895154687124505`*^9, 
   3.889668789180977*^9, 3.8896725087091503`*^9, 3.8896746341294947`*^9, {
   3.88967467876441*^9, 3.8896746953717566`*^9}, {3.889674754509908*^9, 
   3.8896747662462883`*^9}, 3.889674833427221*^9, 3.8896749045918837`*^9, {
   3.889676076787506*^9, 3.8896761358772745`*^9}, 3.889676612828989*^9, 
   3.889676756265704*^9, 3.8902038192855253`*^9, {3.890203856897176*^9, 
   3.890203902283286*^9}, 3.8902059339417963`*^9, 3.8902102574150095`*^9, 
   3.8902167504968033`*^9, 3.8902168293738966`*^9, {3.890216870017076*^9, 
   3.890216876660765*^9}, 3.8902172119334965`*^9, 3.8902178180211363`*^9, 
   3.8909817030480986`*^9, 3.8909818035906286`*^9, 3.8909822364544888`*^9, 
   3.890982755046166*^9, 3.891416112682912*^9, 3.891426801668441*^9, 
   3.8926186413176928`*^9, 3.8926186824334993`*^9, 3.8926189121910763`*^9, 
   3.9023676535337334`*^9, 3.9023726041775*^9},
 CellLabel->
  "Out[2132]=",ExpressionUUID->"37cf6532-d8ff-4dd2-9eb3-6ae21e9dbf25"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Plot", " ", "slopes"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotSlopes", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"default", ":", " ", "0.15"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "6"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"PowerTicks", "[", "True", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}], ",", 
           RowBox[{
            RowBox[{"PowerTicks", "[", "False", "]"}], "[", 
            RowBox[{
             RowBox[{"10", "^", 
              RowBox[{"-", "2"}]}], ",", " ", 
             RowBox[{"10", "^", "0"}]}], "]"}]}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{
       "only", " ", "works", " ", "with", " ", "PowerTicks", " ", "function", 
        " ", "defined", " ", "in", " ", "polydisp", " ", "fitting", " ", 
        "functions", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<Slopes.pdf\>\""}], "}"}], "]"}], ",", "plotSlopes"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"slope", "[", 
    RowBox[{"datamerged", ",", "0.15"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Export", " ", "slopes", " ", 
     RowBox[{"(", 
      RowBox[{
      "for", " ", "plotting", " ", "in", " ", "Python", " ", "or", " ", 
       "other", " ", "software"}], ")"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exportlist", " ", "=", " ", 
     RowBox[{"exportData", "[", 
      RowBox[{"slope", "[", 
       RowBox[{"datamerged", ",", "0.15"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", "\[IndentingNewLine]", 
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"FileBaseName", "[", 
          RowBox[{"NotebookFileName", "[", "]"}], "]"}], "<>", 
         "\"\< SAXS slopes.csv\>\""}]}], "\[IndentingNewLine]", "}"}], 
      "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
     "exportlist"}], "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", 
   RowBox[{"NotebookFileName", "[", "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.852797516969694*^9, {3.852797632109549*^9, 3.852797683131383*^9}, {
   3.852797796480151*^9, 3.852797853718195*^9}, {3.8527978838837643`*^9, 
   3.852797901227326*^9}, {3.852797980320817*^9, 3.852798038102087*^9}, 
   3.852798223135673*^9, {3.852798406664549*^9, 3.852798409306513*^9}, {
   3.852798512004775*^9, 3.852798555547234*^9}, {3.85279858828354*^9, 
   3.852798831366269*^9}, {3.852798896028565*^9, 3.852799007753936*^9}, {
   3.852799080350028*^9, 3.852799084748775*^9}, {3.8527992586158037`*^9, 
   3.8527992606884203`*^9}, {3.852801934781908*^9, 3.85280197103442*^9}, {
   3.852802103164875*^9, 3.852802118419861*^9}, {3.852862635200562*^9, 
   3.8528626398081703`*^9}, {3.85286268207966*^9, 3.85286275183375*^9}, {
   3.852862799533414*^9, 3.852862876114451*^9}, {3.8528629338179607`*^9, 
   3.852862985846582*^9}, {3.852863040437448*^9, 3.852863051004711*^9}, {
   3.852868510428824*^9, 3.852868602768145*^9}, {3.852868644287572*^9, 
   3.85286868020261*^9}, {3.852868718724351*^9, 3.85286873785894*^9}, {
   3.852868770378528*^9, 3.8528689132597523`*^9}, {3.852868965432905*^9, 
   3.852868981650947*^9}, 3.852870677134739*^9, {3.8528710993603067`*^9, 
   3.852871145669981*^9}, {3.8528716178560038`*^9, 3.852871618411791*^9}, {
   3.852874052533587*^9, 3.852874070324737*^9}, {3.8533820192129173`*^9, 
   3.853382032526078*^9}, {3.853403584226432*^9, 3.853403584753387*^9}, {
   3.8534051467395353`*^9, 3.853405196243081*^9}, {3.853405235261485*^9, 
   3.8534052353804817`*^9}, {3.853405414194544*^9, 3.85340541704944*^9}, {
   3.854423706814918*^9, 3.854423713174549*^9}, {3.8601401065322495`*^9, 
   3.8601401162752795`*^9}, {3.8617652315248656`*^9, 3.861765245785426*^9}, {
   3.861765486245756*^9, 3.861765500810083*^9}, {3.8617668960181065`*^9, 
   3.861766896503375*^9}, {3.861766959391518*^9, 3.861766970643777*^9}, {
   3.861768170754223*^9, 3.861768171551543*^9}, {3.861768267366991*^9, 
   3.8617682678668547`*^9}, 3.861940907625001*^9, {3.861941874731223*^9, 
   3.8619418752572*^9}, {3.863686273326891*^9, 3.86368627384243*^9}, 
   3.863687238834276*^9, {3.8895154361670246`*^9, 3.889515452084921*^9}, {
   3.889672427830373*^9, 3.8896724458079796`*^9}, {3.8896763888939342`*^9, 
   3.8896765605915513`*^9}, 3.889676629643072*^9, {3.88967679120571*^9, 
   3.88967681543388*^9}, {3.889676858823769*^9, 3.889676888283419*^9}, {
   3.8926186490246143`*^9, 3.8926186508161917`*^9}},
 CellLabel->
  "In[2133]:=",ExpressionUUID->"8edd1d77-e6da-4feb-ad70-9ef9a39ee410"],

Cell[BoxData[
 GraphicsBox[{{{
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.352012198649872, -1.3931597078962221`}, \
{-5.352012198649872, -1.151834366725471}}], 
         LineBox[{{-5.352012198649872, -1.151834366725471}, \
{-5.352012198649872, -0.9105090255547197}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.197327949963066, -1.3134154073527315`}, \
{-5.197327949963066, -1.069959893773818}}], 
         LineBox[{{-5.197327949963066, -1.069959893773818}, \
{-5.197327949963066, -0.8265043801949042}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-5.046182498246482, -1.9504581230708071`}, \
{-5.046182498246482, -1.6762357931850604`}}], 
         LineBox[{{-5.046182498246482, -1.6762357931850604`}, \
{-5.046182498246482, -1.4020134632993138`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.894444132978499, -2.0135895487593514`}, \
{-4.894444132978499, -1.7375884675911477`}}], 
         LineBox[{{-4.894444132978499, -1.7375884675911477`}, \
{-4.894444132978499, -1.461587386422944}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.745125399370905, -2.1041540613861183`}, \
{-4.745125399370905, -1.8251655604291082`}}], 
         LineBox[{{-4.745125399370905, -1.8251655604291082`}, \
{-4.745125399370905, -1.546177059472098}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.596628633102665, -2.0307430586360637`}, \
{-4.596628633102665, -1.7724110332954253`}}], 
         LineBox[{{-4.596628633102665, -1.7724110332954253`}, \
{-4.596628633102665, -1.5140790079547868`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.447741719114617, -2.0169830121124313`}, \
{-4.447741719114617, -1.7725072919707168`}}], 
         LineBox[{{-4.447741719114617, -1.7725072919707168`}, \
{-4.447741719114617, -1.5280315718290023`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.298711959937622, -2.0626503772314857`}, \
{-4.298711959937622, -1.8496491893256315`}}], 
         LineBox[{{-4.298711959937622, -1.8496491893256315`}, \
{-4.298711959937622, -1.6366480014197775`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.149632905511913, -2.236616860168895}, \
{-4.149632905511913, -2.0325593608914523`}}], 
         LineBox[{{-4.149632905511913, -2.0325593608914523`}, \
{-4.149632905511913, -1.8285018616140096`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-4.001278268975371, -2.126596922805546}, \
{-4.001278268975371, -1.9202406735472024`}}], 
         LineBox[{{-4.001278268975371, -1.9202406735472024`}, \
{-4.001278268975371, -1.7138844242888587`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.8508575458258987`, -2.405553425795285}, \
{-3.8508575458258987`, -2.2031646692537383`}}], 
         LineBox[{{-3.8508575458258987`, -2.2031646692537383`}, \
{-3.8508575458258987`, -2.0007759127121916`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.6998351226863213`, -2.3164167395806587`}, \
{-3.6998351226863213`, -2.134158695867596}}], 
         LineBox[{{-3.6998351226863213`, -2.134158695867596}, \
{-3.6998351226863213`, -1.9519006521545337`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.550260154845919, -2.203216947445259}, \
{-3.550260154845919, -2.0473258241851515`}}], 
         LineBox[{{-3.550260154845919, -2.0473258241851515`}, \
{-3.550260154845919, -1.891434700925044}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.3997502222704012`, -2.2307861716923925`}, \
{-3.3997502222704012`, -2.0800504841837304`}}], 
         LineBox[{{-3.3997502222704012`, -2.0800504841837304`}, \
{-3.3997502222704012`, -1.9293147966750681`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.2492191603155653`, -2.2478328027805525`}, \
{-3.2492191603155653`, -2.1107168701832237`}}], 
         LineBox[{{-3.2492191603155653`, -2.1107168701832237`}, \
{-3.2492191603155653`, -1.973600937585895}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-3.099363949694378, -2.2353296307097104`}, \
{-3.099363949694378, -2.1004607688868693`}}], 
         LineBox[{{-3.099363949694378, -2.1004607688868693`}, \
{-3.099363949694378, -1.9655919070640282`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.9723318619592627`, -2.3858567159594695`}, \
{-2.9723318619592627`, -2.169150133472718}}], 
         LineBox[{{-2.9723318619592627`, -2.169150133472718}, \
{-2.9723318619592627`, -1.9524435509859663`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.8161289018458944`, -2.306313665840845}, \
{-2.8161289018458944`, -2.014061893425849}}], 
         LineBox[{{-2.8161289018458944`, -2.014061893425849}, \
{-2.8161289018458944`, -1.7218101210108534`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.637122953927779, -2.7518917128356595`}, \
{-2.637122953927779, -2.2061952959799984`}}], 
         LineBox[{{-2.637122953927779, -2.2061952959799984`}, \
{-2.637122953927779, -1.6604988791243374`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.4883394437723703`, -2.7366945816937207`}, \
{-2.4883394437723703`, -2.225953227624485}}], 
         LineBox[{{-2.4883394437723703`, -2.225953227624485}, \
{-2.4883394437723703`, -1.7152118735552495`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.3426491274116255`, -2.772455987224709}, \
{-2.3426491274116255`, -2.2921739832968755`}}], 
         LineBox[{{-2.3426491274116255`, -2.2921739832968755`}, \
{-2.3426491274116255`, -1.811891979369042}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.1952323671440643`, -2.7715253067085035`}, \
{-2.1952323671440643`, -2.329483345181388}}], 
         LineBox[{{-2.1952323671440643`, -2.329483345181388}, \
{-2.1952323671440643`, -1.8874413836542725`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-2.048114358050804, -2.8147049786780887`}, \
{-2.048114358050804, -2.3830075094473293`}}], 
         LineBox[{{-2.048114358050804, -2.3830075094473293`}, \
{-2.048114358050804, -1.95131004021657}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.9047213128625353`, -2.832278194104769}, \
{-1.9047213128625353`, -2.4311676688983095`}}], 
         LineBox[{{-1.9047213128625353`, -2.4311676688983095`}, \
{-1.9047213128625353`, -2.0300571436918498`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.7572185227137695`, -2.8846177931737373`}, \
{-1.7572185227137695`, -2.511398827530227}}], 
         LineBox[{{-1.7572185227137695`, -2.511398827530227}, \
{-1.7572185227137695`, -2.1381798618867163`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.6053998639759, -2.9663156495983545`}, \
{-1.6053998639759, -2.61370163284424}}], 
         LineBox[{{-1.6053998639759, -2.61370163284424}, {-1.6053998639759, \
-2.2610876160901254`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.4536487775630647`, -3.0377885868632313`}, \
{-1.4536487775630647`, -2.6973826950774096`}}], 
         LineBox[{{-1.4536487775630647`, -2.6973826950774096`}, \
{-1.4536487775630647`, -2.356976803291588}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.3021571254789979`, -3.144948413067255}, \
{-1.3021571254789979`, -2.8205679377033843`}}], 
         LineBox[{{-1.3021571254789979`, -2.8205679377033843`}, \
{-1.3021571254789979`, -2.4961874623395137`}}]}},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{{}, {
         LineBox[{{-1.1509597708634107`, -3.234763455290838}, \
{-1.1509597708634107`, -2.9191367616169543`}}], 
         LineBox[{{-1.1509597708634107`, -2.9191367616169543`}, \
{-1.1509597708634107`, -2.6035100679430707`}}]}},
       Antialiasing->False]}}, {
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.352012198649872, -0.9105090255547197}, 
            Offset[{3, 
             0}, {-5.352012198649872, -0.9105090255547197}]}, \
{{-5.352012198649872, -0.9105090255547197}, 
            Offset[{-3, 
             0}, {-5.352012198649872, -0.9105090255547197}]}, \
{{-5.352012198649872, -1.3931597078962221`}, 
            Offset[{3, 
             0}, {-5.352012198649872, -1.3931597078962221`}]}, \
{{-5.352012198649872, -1.3931597078962221`}, 
            Offset[{-3, 
             0}, {-5.352012198649872, -1.3931597078962221`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.197327949963066, -0.8265043801949042}, 
            Offset[{3, 
             0}, {-5.197327949963066, -0.8265043801949042}]}, \
{{-5.197327949963066, -0.8265043801949042}, 
            Offset[{-3, 
             0}, {-5.197327949963066, -0.8265043801949042}]}, \
{{-5.197327949963066, -1.3134154073527315`}, 
            Offset[{3, 
             0}, {-5.197327949963066, -1.3134154073527315`}]}, \
{{-5.197327949963066, -1.3134154073527315`}, 
            Offset[{-3, 
             0}, {-5.197327949963066, -1.3134154073527315`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-5.046182498246482, -1.4020134632993138`}, 
            Offset[{3, 
             0}, {-5.046182498246482, -1.4020134632993138`}]}, \
{{-5.046182498246482, -1.4020134632993138`}, 
            Offset[{-3, 
             0}, {-5.046182498246482, -1.4020134632993138`}]}, \
{{-5.046182498246482, -1.9504581230708071`}, 
            Offset[{3, 
             0}, {-5.046182498246482, -1.9504581230708071`}]}, \
{{-5.046182498246482, -1.9504581230708071`}, 
            Offset[{-3, 
             0}, {-5.046182498246482, -1.9504581230708071`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.894444132978499, -1.461587386422944}, 
            Offset[{3, 
             0}, {-4.894444132978499, -1.461587386422944}]}, \
{{-4.894444132978499, -1.461587386422944}, 
            Offset[{-3, 
             0}, {-4.894444132978499, -1.461587386422944}]}, \
{{-4.894444132978499, -2.0135895487593514`}, 
            Offset[{3, 
             0}, {-4.894444132978499, -2.0135895487593514`}]}, \
{{-4.894444132978499, -2.0135895487593514`}, 
            Offset[{-3, 
             0}, {-4.894444132978499, -2.0135895487593514`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.745125399370905, -1.546177059472098}, 
            Offset[{3, 
             0}, {-4.745125399370905, -1.546177059472098}]}, \
{{-4.745125399370905, -1.546177059472098}, 
            Offset[{-3, 
             0}, {-4.745125399370905, -1.546177059472098}]}, \
{{-4.745125399370905, -2.1041540613861183`}, 
            Offset[{3, 
             0}, {-4.745125399370905, -2.1041540613861183`}]}, \
{{-4.745125399370905, -2.1041540613861183`}, 
            Offset[{-3, 
             0}, {-4.745125399370905, -2.1041540613861183`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.596628633102665, -1.5140790079547868`}, 
            Offset[{3, 
             0}, {-4.596628633102665, -1.5140790079547868`}]}, \
{{-4.596628633102665, -1.5140790079547868`}, 
            Offset[{-3, 
             0}, {-4.596628633102665, -1.5140790079547868`}]}, \
{{-4.596628633102665, -2.0307430586360637`}, 
            Offset[{3, 
             0}, {-4.596628633102665, -2.0307430586360637`}]}, \
{{-4.596628633102665, -2.0307430586360637`}, 
            Offset[{-3, 
             0}, {-4.596628633102665, -2.0307430586360637`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.447741719114617, -1.5280315718290023`}, 
            Offset[{3, 
             0}, {-4.447741719114617, -1.5280315718290023`}]}, \
{{-4.447741719114617, -1.5280315718290023`}, 
            Offset[{-3, 
             0}, {-4.447741719114617, -1.5280315718290023`}]}, \
{{-4.447741719114617, -2.0169830121124313`}, 
            Offset[{3, 
             0}, {-4.447741719114617, -2.0169830121124313`}]}, \
{{-4.447741719114617, -2.0169830121124313`}, 
            Offset[{-3, 
             0}, {-4.447741719114617, -2.0169830121124313`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.298711959937622, -1.6366480014197775`}, 
            Offset[{3, 
             0}, {-4.298711959937622, -1.6366480014197775`}]}, \
{{-4.298711959937622, -1.6366480014197775`}, 
            Offset[{-3, 
             0}, {-4.298711959937622, -1.6366480014197775`}]}, \
{{-4.298711959937622, -2.0626503772314857`}, 
            Offset[{3, 
             0}, {-4.298711959937622, -2.0626503772314857`}]}, \
{{-4.298711959937622, -2.0626503772314857`}, 
            Offset[{-3, 
             0}, {-4.298711959937622, -2.0626503772314857`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.149632905511913, -1.8285018616140096`}, 
            Offset[{3, 
             0}, {-4.149632905511913, -1.8285018616140096`}]}, \
{{-4.149632905511913, -1.8285018616140096`}, 
            Offset[{-3, 
             0}, {-4.149632905511913, -1.8285018616140096`}]}, \
{{-4.149632905511913, -2.236616860168895}, 
            Offset[{3, 
             0}, {-4.149632905511913, -2.236616860168895}]}, \
{{-4.149632905511913, -2.236616860168895}, 
            Offset[{-3, 0}, {-4.149632905511913, -2.236616860168895}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-4.001278268975371, -1.7138844242888587`}, 
            Offset[{3, 
             0}, {-4.001278268975371, -1.7138844242888587`}]}, \
{{-4.001278268975371, -1.7138844242888587`}, 
            Offset[{-3, 
             0}, {-4.001278268975371, -1.7138844242888587`}]}, \
{{-4.001278268975371, -2.126596922805546}, 
            Offset[{3, 
             0}, {-4.001278268975371, -2.126596922805546}]}, \
{{-4.001278268975371, -2.126596922805546}, 
            Offset[{-3, 0}, {-4.001278268975371, -2.126596922805546}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.8508575458258987`, -2.0007759127121916`}, 
            Offset[{3, 
             0}, {-3.8508575458258987`, -2.0007759127121916`}]}, \
{{-3.8508575458258987`, -2.0007759127121916`}, 
            Offset[{-3, 
             0}, {-3.8508575458258987`, -2.0007759127121916`}]}, \
{{-3.8508575458258987`, -2.405553425795285}, 
            Offset[{3, 
             0}, {-3.8508575458258987`, -2.405553425795285}]}, \
{{-3.8508575458258987`, -2.405553425795285}, 
            Offset[{-3, 
             0}, {-3.8508575458258987`, -2.405553425795285}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.6998351226863213`, -1.9519006521545337`}, 
            Offset[{3, 
             0}, {-3.6998351226863213`, -1.9519006521545337`}]}, \
{{-3.6998351226863213`, -1.9519006521545337`}, 
            Offset[{-3, 
             0}, {-3.6998351226863213`, -1.9519006521545337`}]}, \
{{-3.6998351226863213`, -2.3164167395806587`}, 
            Offset[{3, 
             0}, {-3.6998351226863213`, -2.3164167395806587`}]}, \
{{-3.6998351226863213`, -2.3164167395806587`}, 
            Offset[{-3, 
             0}, {-3.6998351226863213`, -2.3164167395806587`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.550260154845919, -1.891434700925044}, 
            Offset[{3, 
             0}, {-3.550260154845919, -1.891434700925044}]}, \
{{-3.550260154845919, -1.891434700925044}, 
            Offset[{-3, 
             0}, {-3.550260154845919, -1.891434700925044}]}, \
{{-3.550260154845919, -2.203216947445259}, 
            Offset[{3, 
             0}, {-3.550260154845919, -2.203216947445259}]}, \
{{-3.550260154845919, -2.203216947445259}, 
            Offset[{-3, 0}, {-3.550260154845919, -2.203216947445259}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.3997502222704012`, -1.9293147966750681`}, 
            Offset[{3, 
             0}, {-3.3997502222704012`, -1.9293147966750681`}]}, \
{{-3.3997502222704012`, -1.9293147966750681`}, 
            Offset[{-3, 
             0}, {-3.3997502222704012`, -1.9293147966750681`}]}, \
{{-3.3997502222704012`, -2.2307861716923925`}, 
            Offset[{3, 
             0}, {-3.3997502222704012`, -2.2307861716923925`}]}, \
{{-3.3997502222704012`, -2.2307861716923925`}, 
            Offset[{-3, 
             0}, {-3.3997502222704012`, -2.2307861716923925`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.2492191603155653`, -1.973600937585895}, 
            Offset[{3, 
             0}, {-3.2492191603155653`, -1.973600937585895}]}, \
{{-3.2492191603155653`, -1.973600937585895}, 
            Offset[{-3, 
             0}, {-3.2492191603155653`, -1.973600937585895}]}, \
{{-3.2492191603155653`, -2.2478328027805525`}, 
            Offset[{3, 
             0}, {-3.2492191603155653`, -2.2478328027805525`}]}, \
{{-3.2492191603155653`, -2.2478328027805525`}, 
            Offset[{-3, 
             0}, {-3.2492191603155653`, -2.2478328027805525`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-3.099363949694378, -1.9655919070640282`}, 
            Offset[{3, 
             0}, {-3.099363949694378, -1.9655919070640282`}]}, \
{{-3.099363949694378, -1.9655919070640282`}, 
            Offset[{-3, 
             0}, {-3.099363949694378, -1.9655919070640282`}]}, \
{{-3.099363949694378, -2.2353296307097104`}, 
            Offset[{3, 
             0}, {-3.099363949694378, -2.2353296307097104`}]}, \
{{-3.099363949694378, -2.2353296307097104`}, 
            Offset[{-3, 
             0}, {-3.099363949694378, -2.2353296307097104`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.9723318619592627`, -1.9524435509859663`}, 
            Offset[{3, 
             0}, {-2.9723318619592627`, -1.9524435509859663`}]}, \
{{-2.9723318619592627`, -1.9524435509859663`}, 
            Offset[{-3, 
             0}, {-2.9723318619592627`, -1.9524435509859663`}]}, \
{{-2.9723318619592627`, -2.3858567159594695`}, 
            Offset[{3, 
             0}, {-2.9723318619592627`, -2.3858567159594695`}]}, \
{{-2.9723318619592627`, -2.3858567159594695`}, 
            Offset[{-3, 
             0}, {-2.9723318619592627`, -2.3858567159594695`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.8161289018458944`, -1.7218101210108534`}, 
            Offset[{3, 
             0}, {-2.8161289018458944`, -1.7218101210108534`}]}, \
{{-2.8161289018458944`, -1.7218101210108534`}, 
            Offset[{-3, 
             0}, {-2.8161289018458944`, -1.7218101210108534`}]}, \
{{-2.8161289018458944`, -2.306313665840845}, 
            Offset[{3, 
             0}, {-2.8161289018458944`, -2.306313665840845}]}, \
{{-2.8161289018458944`, -2.306313665840845}, 
            Offset[{-3, 
             0}, {-2.8161289018458944`, -2.306313665840845}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.637122953927779, -1.6604988791243374`}, 
            Offset[{3, 
             0}, {-2.637122953927779, -1.6604988791243374`}]}, \
{{-2.637122953927779, -1.6604988791243374`}, 
            Offset[{-3, 
             0}, {-2.637122953927779, -1.6604988791243374`}]}, \
{{-2.637122953927779, -2.7518917128356595`}, 
            Offset[{3, 
             0}, {-2.637122953927779, -2.7518917128356595`}]}, \
{{-2.637122953927779, -2.7518917128356595`}, 
            Offset[{-3, 
             0}, {-2.637122953927779, -2.7518917128356595`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.4883394437723703`, -1.7152118735552495`}, 
            Offset[{3, 
             0}, {-2.4883394437723703`, -1.7152118735552495`}]}, \
{{-2.4883394437723703`, -1.7152118735552495`}, 
            Offset[{-3, 
             0}, {-2.4883394437723703`, -1.7152118735552495`}]}, \
{{-2.4883394437723703`, -2.7366945816937207`}, 
            Offset[{3, 
             0}, {-2.4883394437723703`, -2.7366945816937207`}]}, \
{{-2.4883394437723703`, -2.7366945816937207`}, 
            Offset[{-3, 
             0}, {-2.4883394437723703`, -2.7366945816937207`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.3426491274116255`, -1.811891979369042}, 
            Offset[{3, 
             0}, {-2.3426491274116255`, -1.811891979369042}]}, \
{{-2.3426491274116255`, -1.811891979369042}, 
            Offset[{-3, 
             0}, {-2.3426491274116255`, -1.811891979369042}]}, \
{{-2.3426491274116255`, -2.772455987224709}, 
            Offset[{3, 
             0}, {-2.3426491274116255`, -2.772455987224709}]}, \
{{-2.3426491274116255`, -2.772455987224709}, 
            Offset[{-3, 
             0}, {-2.3426491274116255`, -2.772455987224709}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.1952323671440643`, -1.8874413836542725`}, 
            Offset[{3, 
             0}, {-2.1952323671440643`, -1.8874413836542725`}]}, \
{{-2.1952323671440643`, -1.8874413836542725`}, 
            Offset[{-3, 
             0}, {-2.1952323671440643`, -1.8874413836542725`}]}, \
{{-2.1952323671440643`, -2.7715253067085035`}, 
            Offset[{3, 
             0}, {-2.1952323671440643`, -2.7715253067085035`}]}, \
{{-2.1952323671440643`, -2.7715253067085035`}, 
            Offset[{-3, 
             0}, {-2.1952323671440643`, -2.7715253067085035`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-2.048114358050804, -1.95131004021657}, 
            Offset[{3, 
             0}, {-2.048114358050804, -1.95131004021657}]}, \
{{-2.048114358050804, -1.95131004021657}, 
            Offset[{-3, 
             0}, {-2.048114358050804, -1.95131004021657}]}, \
{{-2.048114358050804, -2.8147049786780887`}, 
            Offset[{3, 
             0}, {-2.048114358050804, -2.8147049786780887`}]}, \
{{-2.048114358050804, -2.8147049786780887`}, 
            Offset[{-3, 
             0}, {-2.048114358050804, -2.8147049786780887`}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.9047213128625353`, -2.0300571436918498`}, 
            Offset[{3, 
             0}, {-1.9047213128625353`, -2.0300571436918498`}]}, \
{{-1.9047213128625353`, -2.0300571436918498`}, 
            Offset[{-3, 
             0}, {-1.9047213128625353`, -2.0300571436918498`}]}, \
{{-1.9047213128625353`, -2.832278194104769}, 
            Offset[{3, 
             0}, {-1.9047213128625353`, -2.832278194104769}]}, \
{{-1.9047213128625353`, -2.832278194104769}, 
            Offset[{-3, 
             0}, {-1.9047213128625353`, -2.832278194104769}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.7572185227137695`, -2.1381798618867163`}, 
            Offset[{3, 
             0}, {-1.7572185227137695`, -2.1381798618867163`}]}, \
{{-1.7572185227137695`, -2.1381798618867163`}, 
            Offset[{-3, 
             0}, {-1.7572185227137695`, -2.1381798618867163`}]}, \
{{-1.7572185227137695`, -2.8846177931737373`}, 
            Offset[{3, 
             0}, {-1.7572185227137695`, -2.8846177931737373`}]}, \
{{-1.7572185227137695`, -2.8846177931737373`}, 
            Offset[{-3, 
             0}, {-1.7572185227137695`, -2.8846177931737373`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.6053998639759, -2.2610876160901254`}, 
            Offset[{3, 
             0}, {-1.6053998639759, -2.2610876160901254`}]}, \
{{-1.6053998639759, -2.2610876160901254`}, 
            Offset[{-3, 
             0}, {-1.6053998639759, -2.2610876160901254`}]}, \
{{-1.6053998639759, -2.9663156495983545`}, 
            Offset[{3, 
             0}, {-1.6053998639759, -2.9663156495983545`}]}, \
{{-1.6053998639759, -2.9663156495983545`}, 
            Offset[{-3, 0}, {-1.6053998639759, -2.9663156495983545`}]}}], {{{
          1., 0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.4536487775630647`, -2.356976803291588}, 
            Offset[{3, 
             0}, {-1.4536487775630647`, -2.356976803291588}]}, \
{{-1.4536487775630647`, -2.356976803291588}, 
            Offset[{-3, 
             0}, {-1.4536487775630647`, -2.356976803291588}]}, \
{{-1.4536487775630647`, -3.0377885868632313`}, 
            Offset[{3, 
             0}, {-1.4536487775630647`, -3.0377885868632313`}]}, \
{{-1.4536487775630647`, -3.0377885868632313`}, 
            Offset[{-3, 
             0}, {-1.4536487775630647`, -3.0377885868632313`}]}}], {{{1., 
          0.}, {0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.3021571254789979`, -2.4961874623395137`}, 
            Offset[{3, 
             0}, {-1.3021571254789979`, -2.4961874623395137`}]}, \
{{-1.3021571254789979`, -2.4961874623395137`}, 
            Offset[{-3, 
             0}, {-1.3021571254789979`, -2.4961874623395137`}]}, \
{{-1.3021571254789979`, -3.144948413067255}, 
            Offset[{3, 
             0}, {-1.3021571254789979`, -3.144948413067255}]}, \
{{-1.3021571254789979`, -3.144948413067255}, 
            Offset[{-3, 
             0}, {-1.3021571254789979`, -3.144948413067255}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}, 
     {RGBColor[0.368417, 0.506779, 0.709798], 
      StyleBox[{
        GeometricTransformationBox[
         LineBox[{}], {{{1., 0.}, {0., 1.}}, {0., 0.}}], 
        GeometricTransformationBox[
         LineBox[{{{-1.1509597708634107`, -2.6035100679430707`}, 
            Offset[{3, 
             0}, {-1.1509597708634107`, -2.6035100679430707`}]}, \
{{-1.1509597708634107`, -2.6035100679430707`}, 
            Offset[{-3, 
             0}, {-1.1509597708634107`, -2.6035100679430707`}]}, \
{{-1.1509597708634107`, -3.234763455290838}, 
            Offset[{3, 
             0}, {-1.1509597708634107`, -3.234763455290838}]}, \
{{-1.1509597708634107`, -3.234763455290838}, 
            Offset[{-3, 
             0}, {-1.1509597708634107`, -3.234763455290838}]}}], {{{1., 0.}, {
          0., 1.}}, {0., 0.}}]},
       Antialiasing->False]}}}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwB4QEe/iFib1JlAgAAAB0AAAACAAAAHvrD4nVoFcCS6nff6W3yv162jlYQ
yhTAlqT8Q44e8b8Cd/52Si8UwM7UgZ/c0fq/iPesKemTE8AsX6OQKc37vy/e
FicC+xLAqkF9zeAz/b/tIcyd8mISwLks8avLW/y/wJsiznzKEcDX+C6bMFz8
v7JsS4zhMRHAvp+TvymY/b8GUU5eOZkQwNuocXuuQgDAYsctF08BEMATWdVI
Trn+vzYEp2aOzg7AAS5RzBSgAcA7PSQoQ5kNwH3NWcvBEgHASNfKy+5mDMBB
DZlc7GAAwMbCmT6wMgvA4sgcgvGjAMBIvHidZv4JwF1rxIa/4gDAv7WSU3/L
CMBxMydgvs0AwGLKX+1VxwfA7QibYmtaAcDz/PWWbocGwCUSY3vMHADAsDRV
69MYBcDHlSa4SaYBwBXLooIe6APAHJXYkMDOAcAP42HTvr0CwF0EOFBfVgLA
DgnA/NWPAcDCCwEqyKICwLJe0seJYgDA65a5PWYQA8AE0isOvXn+vxwW6AgI
cwPAerJvK5Ed/L/7o7tEWBcEwCx4jMS3r/m/4IrUZtzoBMBTD3g4JUL3vwM7
4WA9lAXAe/jCtaLV9L9ZqETshZAGwIjr7cpUavK/wJHdX2RaB8BQju9P
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-6.907755278982122, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{367.456787109375, Automatic},
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.907755278982137, 0.}, {-6., 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], Automatic}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.8914268911207743`*^9, 
   3.8926186523763256`*^9, 3.8926186857701473`*^9, 3.892618917765296*^9, 
   3.9023676641157813`*^9, 3.902372612413048*^9},
 CellLabel->
  "Out[2133]=",ExpressionUUID->"a1caf155-d33d-4393-8cfa-48a21c82c930"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C15 - \
1.05\\\\Slopes.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.8914268911207743`*^9, 
   3.8926186523763256`*^9, 3.8926186857701473`*^9, 3.892618917765296*^9, 
   3.9023676641157813`*^9, 3.9023726128103924`*^9},
 CellLabel->
  "Out[2134]=",ExpressionUUID->"f477bcdb-a690-4993-963b-b518f6e77849"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.004738606382434237`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.15", "0.24"},
       "Around"],
      Around[-1.151834366725471, 0.24132534117075122`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.005531324668202713`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.07", "0.24"},
       "Around"],
      Around[-1.069959893773818, 0.2434555135789137]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.006433847850044723`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.68", "0.27"},
       "Around"],
      Around[-1.6762357931850604`, 0.27422232988574674`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.007488070438661962`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.74", "0.28"},
       "Around"],
      Around[-1.7375884675911477`, 0.27600108116820365`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.008693971718852027`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.83", "0.28"},
       "Around"],
      Around[-1.8251655604291082`, 0.27898850095701005`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.010085781360330545`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.77", "0.26"},
       "Around"],
      Around[-1.7724110332954253`, 0.25833202534063854`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.011704970256750767`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.77", "0.24"},
       "Around"],
      Around[-1.7725072919707168`, 0.24447572014171443`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.013586047120071366`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.85", "0.21"},
       "Around"],
      Around[-1.8496491893256315`, 0.213001187905854]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.015770204577577458`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.03", "0.20"},
       "Around"],
      Around[-2.0325593608914523`, 0.20405749927744274`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.018292241533021454`", ",", 
     InterpretationBox[
      TemplateBox[{"-1.92", "0.21"},
       "Around"],
      Around[-1.9202406735472024`, 0.2063562492583437]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.021261495911379928`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.20", "0.20"},
       "Around"],
      Around[-2.2031646692537383`, 0.20238875654154692`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02472760315503566`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.13", "0.18"},
       "Around"],
      Around[-2.134158695867596, 0.18225804371306262`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02871716777200143`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.05", "0.16"},
       "Around"],
      Around[-2.0473258241851515`, 0.1558911232601075]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03338160690107378`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.08", "0.15"},
       "Around"],
      Around[-2.0800504841837304`, 0.1507356875086622]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.038804496095529786`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.11", "0.14"},
       "Around"],
      Around[-2.1107168701832237`, 0.13711593259732882`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04507786506699304`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.10", "0.13"},
       "Around"],
      Around[-2.1004607688868693`, 0.13486886182284105`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05118381746874888`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.17", "0.22"},
       "Around"],
      Around[-2.169150133472718, 0.2167065824867516]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05983713035005583`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.01", "0.29"},
       "Around"],
      Around[-2.014061893425849, 0.2922517724149958]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.07156687484278981`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.2", "0.5"},
       "Around"],
      Around[-2.2061952959799984`, 0.5456964168556611]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0830477576097193`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.2", "0.5"},
       "Around"],
      Around[-2.225953227624485, 0.5107413540692357]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.0960727917529942`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.5"},
       "Around"],
      Around[-2.2921739832968755`, 0.4802820039278335]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1113326884401501`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.3", "0.4"},
       "Around"],
      Around[-2.329483345181388, 0.4420419615271156]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1289778805341014`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.4", "0.4"},
       "Around"],
      Around[-2.3830075094473293`, 0.4316974692307593]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.148864123358208`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.4", "0.4"},
       "Around"],
      Around[-2.4311676688983095`, 0.4011105252064599]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.17252406884397548`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.5", "0.4"},
       "Around"],
      Around[-2.511398827530227, 0.3732189656435107]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2008092424721844`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.61", "0.35"},
       "Around"],
      Around[-2.61370163284424, 0.35261401675411447`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.23371595287707908`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.70", "0.34"},
       "Around"],
      Around[-2.6973826950774096`, 0.34040589178582176`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2719445413748963`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.82", "0.32"},
       "Around"],
      Around[-2.8205679377033843`, 0.32438047536387077`]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.316333016423454`", ",", 
     InterpretationBox[
      TemplateBox[{"-2.92", "0.32"},
       "Around"],
      Around[-2.9191367616169543`, 0.3156266936738835]]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.8914268911207743`*^9, 
   3.8926186523763256`*^9, 3.8926186857701473`*^9, 3.892618917765296*^9, 
   3.9023676641157813`*^9, 3.9023726128301134`*^9},
 CellLabel->
  "Out[2135]=",ExpressionUUID->"3abdc7e1-9352-40bb-8b01-a3e4f43239e2"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C15 - 1.05\\\\Sample \
playground LH-ESRF-C15 NEW SAXS slopes.csv\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.8914268911207743`*^9, 
   3.8926186523763256`*^9, 3.8926186857701473`*^9, 3.892618917765296*^9, 
   3.9023676641157813`*^9, 3.902372612917778*^9},
 CellLabel->
  "Out[2137]=",ExpressionUUID->"69906934-e694-49bd-9238-3862c1c69c2a"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C15 - 1.05\\\\Sample \
playground LH-ESRF-C15 NEW.nb\"\>"], "Output",
 CellChangeTimes->{
  3.852797345983632*^9, {3.852797675781699*^9, 3.852797695678535*^9}, 
   3.852797816698617*^9, 3.8527979046846867`*^9, {3.852797989212296*^9, 
   3.852798038960855*^9}, 3.852798522749322*^9, {3.852798578042531*^9, 
   3.852798621271277*^9}, 3.8527986774171886`*^9, {3.852798746320681*^9, 
   3.8527987989025307`*^9}, 3.85279883319804*^9, {3.8527988977815037`*^9, 
   3.852798988466496*^9}, {3.852799066571772*^9, 3.852799085595117*^9}, 
   3.852799371236321*^9, {3.852801936937695*^9, 3.852801973543593*^9}, {
   3.852802104655958*^9, 3.852802119561268*^9}, 3.852862500410799*^9, 
   3.852862533883133*^9, {3.852862701607958*^9, 3.852862752832765*^9}, 
   3.852862800589758*^9, {3.852862841572309*^9, 3.85286287853053*^9}, {
   3.852862961040063*^9, 3.852862987162868*^9}, {3.852863041784163*^9, 
   3.852863052517976*^9}, {3.85286851855713*^9, 3.852868563456098*^9}, 
   3.8528686112469378`*^9, {3.852868645635429*^9, 3.852868681292514*^9}, {
   3.852868719950995*^9, 3.852868738834832*^9}, 3.852868916826046*^9, {
   3.852868968202001*^9, 3.85286898265627*^9}, 3.852870678975832*^9, {
   3.8528711007779913`*^9, 3.852871118216545*^9}, 3.85287115355669*^9, 
   3.8528716206367083`*^9, 3.852874084668347*^9, 3.853381370706914*^9, 
   3.853381477907443*^9, 3.853382039594591*^9, 3.85338235753389*^9, 
   3.853402538913465*^9, 3.853403585786399*^9, 3.853405167845274*^9, 
   3.853405199586698*^9, 3.8534052376911182`*^9, 3.853405419430604*^9, {
   3.853409759182901*^9, 3.85340977227461*^9}, 3.8534101965227337`*^9, 
   3.853410249470071*^9, {3.853410575932642*^9, 3.853410598926773*^9}, 
   3.853469099635906*^9, 3.853469309131391*^9, 3.8534962859629583`*^9, 
   3.853499637160716*^9, 3.853817851525353*^9, 3.853818263087407*^9, 
   3.853824688277567*^9, 3.853824875156226*^9, 3.853833080309764*^9, 
   3.8538364568591433`*^9, 3.8538367165690203`*^9, 3.853838543473041*^9, 
   3.854072558698359*^9, 3.854091679143179*^9, 3.854098465796619*^9, 
   3.854420763080948*^9, 3.8544215348281403`*^9, 3.854423713611958*^9, 
   3.860120822653838*^9, 3.860120994984702*^9, 3.860121301461205*^9, 
   3.861765157588767*^9, {3.8617652327352104`*^9, 3.861765246883433*^9}, {
   3.8617654618721933`*^9, 3.861765495117054*^9}, 3.8617669010806527`*^9, {
   3.8617669653893194`*^9, 3.8617669711987777`*^9}, {3.8617681636139946`*^9, 
   3.861768172620324*^9}, {3.8617682638779945`*^9, 3.861768268816891*^9}, 
   3.861941031402981*^9, 3.8619503251086683`*^9, 3.8636862757494583`*^9, 
   3.863687240140381*^9, 3.885975752049604*^9, 3.885976865574806*^9, 
   3.885976952011711*^9, 3.8859772099410114`*^9, 3.8859772799657326`*^9, 
   3.8859777404306726`*^9, 3.885977787111581*^9, 3.8859795103782063`*^9, 
   3.885980164747009*^9, 3.885980479715824*^9, 3.8859806419052787`*^9, 
   3.8859808116886177`*^9, 3.886063156226128*^9, 3.8860712486314845`*^9, 
   3.888310980288575*^9, 3.888311308510944*^9, 3.889060346347356*^9, 
   3.889064571126178*^9, 3.8890819159217157`*^9, 3.889082752421399*^9, 
   3.889084482404039*^9, 3.8895043087134247`*^9, 3.8895154534729757`*^9, 
   3.8896688023607087`*^9, 3.8896724468191605`*^9, {3.889676431056512*^9, 
   3.8896764550519114`*^9}, {3.8896765019285583`*^9, 3.8896765617701*^9}, {
   3.8896766223493395`*^9, 3.889676630450638*^9}, 3.8896767650691853`*^9, 
   3.8896768162718754`*^9, {3.8896768629395857`*^9, 3.8896768889532757`*^9}, 
   3.89020392289333*^9, 3.890205948951085*^9, 3.890210264027658*^9, 
   3.8902168394329166`*^9, 3.8902168818527*^9, 3.8902172179744573`*^9, 
   3.8902178258568845`*^9, 3.8909818360454464`*^9, 3.8909822668066454`*^9, 
   3.890982759573165*^9, 3.891416145956769*^9, 3.8914268911207743`*^9, 
   3.8926186523763256`*^9, 3.8926186857701473`*^9, 3.892618917765296*^9, 
   3.9023676641157813`*^9, 3.902372612952013*^9},
 CellLabel->
  "Out[2138]=",ExpressionUUID->"5b28c5c1-d3a6-4e84-b0d0-1c9489a1d845"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fitting slopes using L + R (thickness + radius)", "Subsubsection",
 CellChangeTimes->{{3.8890831159415197`*^9, 3.889083129907494*^9}, {
  3.8895043397252035`*^9, 
  3.889504346042064*^9}},ExpressionUUID->"c264222d-eedd-4632-bf2a-\
25682c9a5ec9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fitSlopeLRResult", "=", 
  RowBox[{"fitSlopeLR", "[", 
   RowBox[{
   "datamerged", ",", " ", "2.6", ",", " ", "0.5", ",", " ", "6", ",", " ", 
    "0.5"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8890831508560247`*^9, 3.889083186178582*^9}, {
  3.889083221328817*^9, 3.889083280853166*^9}, {3.890210231443339*^9, 
  3.8902102343651667`*^9}},
 CellLabel->
  "In[2146]:=",ExpressionUUID->"245caa09-fb84-4947-ab47-dd7c0b5b4707"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.562579712429157`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.5710448445599039`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.057650998993838`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.37394628668100954`"}],
  SequenceForm[
  "\[Mu]l = ", 2.562579712429157, " \[Sigma]l = ", 0.5710448445599039, 
   " \[Mu]r = ", 6.057650998993838 " \[Sigma]r = ", 0.37394628668100954`],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.90237263635995*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"93dd0512-c227-4033-b5c1-521284fb1a35"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.5248582046214323`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.658788389813223`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.106687755734635`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.3411091708137025`"}],
  SequenceForm[
  "\[Mu]l = ", 2.5248582046214323`, " \[Sigma]l = ", 0.658788389813223, 
   " \[Mu]r = ", 6.106687755734635 " \[Sigma]r = ", 0.3411091708137025],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372638832446*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"932474c5-3434-4132-a05b-d09ba9cd8c47"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.5394180998506117`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.6405565877374663`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.101740763632425`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.3693243138205197`"}],
  SequenceForm[
  "\[Mu]l = ", 2.5394180998506117`, " \[Sigma]l = ", 0.6405565877374663, 
   " \[Mu]r = ", 6.101740763632425 " \[Sigma]r = ", 0.3693243138205197],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.9023726414611735`*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"6ba981a1-2535-4a53-9a99-2e63b11698d2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.557484865762695`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.629867426762404`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.123303547317558`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.3838372649387283`"}],
  SequenceForm[
  "\[Mu]l = ", 2.557484865762695, " \[Sigma]l = ", 0.629867426762404, 
   " \[Mu]r = ", 6.123303547317558 " \[Sigma]r = ", 0.3838372649387283],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.9023726439148283`*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"4ccb4c2c-47b5-4309-8790-ed7dfc39a5ea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.58975948441479`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.6341742089279514`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.185366474167934`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.4165309353704549`"}],
  SequenceForm[
  "\[Mu]l = ", 2.58975948441479, " \[Sigma]l = ", 0.6341742089279514, 
   " \[Mu]r = ", 6.185366474167934 " \[Sigma]r = ", 0.4165309353704549],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372646511529*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"9255ad06-16ed-4419-985a-be1f4556bfd6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.654096130444385`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.668044970450387`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.3306682988467475`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.4783918511387848`"}],
  SequenceForm[
  "\[Mu]l = ", 2.654096130444385, " \[Sigma]l = ", 0.668044970450387, 
   " \[Mu]r = ", 6.3306682988467475` " \[Sigma]r = ", 0.4783918511387848],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372648889884*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"bd4a09cf-49cb-4a25-92b7-341b5a3dacc0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.7212591944604005`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7131644023666758`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.485579781113749`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5227195250176443`"}],
  SequenceForm[
  "\[Mu]l = ", 2.7212591944604005`, " \[Sigma]l = ", 0.7131644023666758, 
   " \[Mu]r = ", 6.485579781113749 " \[Sigma]r = ", 0.5227195250176443],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372651294756*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"dbb9e601-89ed-4e30-97c4-ca2ead22dbee"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.7746319931225147`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.750496552176822`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.597983977306752`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5624018559513823`"}],
  SequenceForm[
  "\[Mu]l = ", 2.7746319931225147`, " \[Sigma]l = ", 0.750496552176822, 
   " \[Mu]r = ", 6.597983977306752 " \[Sigma]r = ", 0.5624018559513823],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372653723549*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"58f19604-0f67-4e5e-a442-e79567e451a0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.8053840705713444`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7638030411236952`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.650370807161902`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5705350309027958`"}],
  SequenceForm[
  "\[Mu]l = ", 2.8053840705713444`, " \[Sigma]l = ", 0.7638030411236952, 
   " \[Mu]r = ", 6.650370807161902 " \[Sigma]r = ", 0.5705350309027958],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.9023726569338245`*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"eeb00d6a-0314-4a42-982a-8a4e2178e5e3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.8206343036936925`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7692350848439374`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.671459836702726`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5785887525749651`"}],
  SequenceForm[
  "\[Mu]l = ", 2.8206343036936925`, " \[Sigma]l = ", 0.7692350848439374, 
   " \[Mu]r = ", 6.671459836702726 " \[Sigma]r = ", 0.5785887525749651],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372659323532*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"587c6ed9-e824-449a-9615-7c2eccdc9ae0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.8386588979753524`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7754159153060612`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.688066543862828`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5844954711582073`"}],
  SequenceForm[
  "\[Mu]l = ", 2.8386588979753524`, " \[Sigma]l = ", 0.7754159153060612, 
   " \[Mu]r = ", 6.688066543862828 " \[Sigma]r = ", 0.5844954711582073],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.9023726616410513`*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"148ae11f-5df2-41cc-a188-efcfe911d51a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.8632466566228048`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.7846026554564773`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.6982212389790075`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5882143925186143`"}],
  SequenceForm[
  "\[Mu]l = ", 2.8632466566228048`, " \[Sigma]l = ", 0.7846026554564773, 
   " \[Mu]r = ", 6.6982212389790075` " \[Sigma]r = ", 0.5882143925186143],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.9023726646064267`*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"740f8775-9528-4e03-9efa-ce7b74c7b432"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.9190652289929333`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.807198703217188`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.696700910568147`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5886937651183203`"}],
  SequenceForm[
  "\[Mu]l = ", 2.9190652289929333`, " \[Sigma]l = ", 0.807198703217188, 
   " \[Mu]r = ", 6.696700910568147 " \[Sigma]r = ", 0.5886937651183203],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372667435162*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"a6910a54-6bfd-4b2f-9a04-769342f5491d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "2.993054857113184`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8393426912754481`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.659061180373025`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5780616276126811`"}],
  SequenceForm[
  "\[Mu]l = ", 2.993054857113184, " \[Sigma]l = ", 0.8393426912754481, 
   " \[Mu]r = ", 6.659061180373025 " \[Sigma]r = ", 0.5780616276126811],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.9023726701963716`*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"2e926f87-819e-4138-9b88-fafb65fb2b0d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.0355400286854897`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8594865832945963`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.601657318795668`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5605128244981399`"}],
  SequenceForm[
  "\[Mu]l = ", 3.0355400286854897`, " \[Sigma]l = ", 0.8594865832945963, 
   " \[Mu]r = ", 6.601657318795668 " \[Sigma]r = ", 0.5605128244981399],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372672823171*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"65dd54f0-7de2-4fbd-9b22-5e02d3f84323"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.0305088038614523`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8590139871391759`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.579838343031827`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5528764639665452`"}],
  SequenceForm[
  "\[Mu]l = ", 3.0305088038614523`, " \[Sigma]l = ", 0.8590139871391759, 
   " \[Mu]r = ", 6.579838343031827 " \[Sigma]r = ", 0.5528764639665452],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372675291271*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"7f7fa1be-8ce6-4db9-9fd8-5a6325c2c6bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.014365838502486`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8534452088689797`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.571409074633415`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.549508584221349`"}],
  SequenceForm[
  "\[Mu]l = ", 3.014365838502486, " \[Sigma]l = ", 0.8534452088689797, 
   " \[Mu]r = ", 6.571409074633415 " \[Sigma]r = ", 0.549508584221349],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372677849553*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"8eae9235-61c0-4de1-8fc0-70f8f82910dd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.010689236101645`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8520064110795643`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.571207021815592`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5494802003970617`"}],
  SequenceForm[
  "\[Mu]l = ", 3.010689236101645, " \[Sigma]l = ", 0.8520064110795643, 
   " \[Mu]r = ", 6.571207021815592 " \[Sigma]r = ", 0.5494802003970617],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372680543932*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"0400825e-be69-4697-bc5c-5a7aa7d647a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.0103268211453424`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8518706271116425`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.571619826851188`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5496322699065781`"}],
  SequenceForm[
  "\[Mu]l = ", 3.0103268211453424`, " \[Sigma]l = ", 0.8518706271116425, 
   " \[Mu]r = ", 6.571619826851188 " \[Sigma]r = ", 0.5496322699065781],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372683076504*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"4467b6d0-4405-4cf3-a164-2158b6cea4b6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.0103323279876415`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8518690391319624`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.571624040621457`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5496385942923305`"}],
  SequenceForm[
  "\[Mu]l = ", 3.0103323279876415`, " \[Sigma]l = ", 0.8518690391319624, 
   " \[Mu]r = ", 6.571624040621457 " \[Sigma]r = ", 0.5496385942923305],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.9023726857680006`*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"80607445-0b5b-455c-b185-e4357f4b089e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.0103365239521986`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8518712604468458`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.571629565584752`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5496399332121835`"}],
  SequenceForm[
  "\[Mu]l = ", 3.0103365239521986`, " \[Sigma]l = ", 0.8518712604468458, 
   " \[Mu]r = ", 6.571629565584752 " \[Sigma]r = ", 0.5496399332121835],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372688348504*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"ce7fbced-a383-46ba-a842-0a3853deec6e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Mu]l = \"\>", "\[InvisibleSpace]", "3.0103365239500604`", 
   "\[InvisibleSpace]", "\<\" \[Sigma]l = \"\>", "\[InvisibleSpace]", 
   "0.8518712604455686`", "\[InvisibleSpace]", "\<\" \[Mu]r = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"6.5716295655797445`", " ", "\<\" \[Sigma]r = \"\>"}], 
   "\[InvisibleSpace]", "0.5496399332107043`"}],
  SequenceForm[
  "\[Mu]l = ", 3.0103365239500604`, " \[Sigma]l = ", 0.8518712604455686, 
   " \[Mu]r = ", 6.5716295655797445` " \[Sigma]r = ", 0.5496399332107043],
  Editable->False]], "Print",
 CellChangeTimes->{3.8914909506894035`*^9, 3.8926187077718725`*^9, 
  3.8926190298167424`*^9, 3.90236770839368*^9, 3.902372715365897*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"5de6f125-b3ea-492c-8165-df44a5899944"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "FindMinimum", "lstol", 
   "\"The line search decreased the step size to within the tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the function. You may need more than \\!\\(\\*RowBox[{\
\\\"MachinePrecision\\\"}]\\) digits of working precision to meet these \
tolerances.\"", 2, 2146, 149, 17025713724928210084, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.891491200831779*^9, 3.892618856196306*^9, 
  3.8926192341151314`*^9, 3.902367896039336*^9, 3.902372762368312*^9},
 CellLabel->
  "During evaluation of \
In[2146]:=",ExpressionUUID->"f6a24fcc-3527-4959-97c7-6775dd5b10ad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Mu]l", "\[Rule]", "3.010336523916701`"}], ",", 
   RowBox[{"\[Sigma]l", "\[Rule]", "0.8518712604178006`"}], ",", 
   RowBox[{"\[Mu]r", "\[Rule]", "6.571629565299034`"}], ",", 
   RowBox[{"\[Sigma]r", "\[Rule]", "0.5496399331270879`"}], ",", 
   RowBox[{"\[Mu]lx", "\[Rule]", "29.17111029550334`"}], ",", 
   RowBox[{"\[Sigma]lx", "\[Rule]", "30.120427765880418`"}], ",", 
   RowBox[{"\[Mu]rx", "\[Rule]", "831.0430456580035`"}], ",", 
   RowBox[{"\[Sigma]rx", "\[Rule]", "493.54580643228456`"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8890831915134697`*^9, 3.889083231716405*^9, 
  3.889084522029305*^9, 3.889504478964719*^9, 3.889668839037505*^9, 
  3.8896689977438555`*^9, 3.8902046298151426`*^9, 3.8902062509864902`*^9, 
  3.8902104624878206`*^9, 3.890216989995762*^9, 3.8902173041350584`*^9, 
  3.8902179907784314`*^9, 3.8909820012674875`*^9, 3.8909824058680325`*^9, 
  3.890982955030755*^9, 3.8909840701831517`*^9, 3.8909841450834846`*^9, 
  3.8909843770126934`*^9, 3.8909844264654613`*^9, 3.890984470131813*^9, 
  3.8914172771083*^9, 3.8914183694354115`*^9, 3.89142833097868*^9, 
  3.8914909230011034`*^9, 3.891491200867608*^9, 3.8926188562515326`*^9, 
  3.892619234142315*^9, 3.902367896076027*^9, 3.9023727624052534`*^9},
 CellLabel->
  "Out[2146]=",ExpressionUUID->"e78d1964-0349-4c6e-b17b-7817d5284570"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"ColorData", "[", 
    RowBox[{"\"\<SunsetColors\>\"", ",", "\"\<Image\>\""}], "]"}], "*)"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Visualize", " ", "a", " ", "color", " ", "scheme"}], "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"plotIntensityFitPlatelets", " ", "=", " ", 
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}]}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"calculateIntensitiesLR", "[", 
          RowBox[{
          "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
          "]"}], "/.", "fitSlopeLRResult"}]}], "}"}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"Optional", ":", " ", 
        RowBox[{
        "Plot", " ", "every", " ", "2", "nd", " ", "point", " ", "only", " ", 
         "for", " ", "readibility"}], ":", " ", 
        RowBox[{"datamerged", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", 
           RowBox[{"-", "1"}], ";;", "2"}], "]"}], "]"}]}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"5", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "3"}]}]}], ",", " ", 
           RowBox[{"10", "^", "0"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"10", "^", 
            RowBox[{"-", "6"}]}], ",", " ", 
           RowBox[{"10", "^", "2"}]}], "}"}]}], "}"}]}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Intensity [a.u.]\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "third", " ", "color", " ", "not", " ", "currently", " ", "used"}], 
        ",", " ", 
        RowBox[{
        "but", " ", "left", " ", "here", " ", "for", " ", "reference", " ", 
         "as", " ", "it", " ", "has", " ", "a", " ", "pretty", " ", "decent", 
         " ", "contrast", " ", "with", " ", "the", " ", "first", " ", 
         "color"}]}], " ", "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"ColorData", "[", "9", "]"}], "[", "i", "]"}], ",", 
            RowBox[{"PointSize", "[", "0.01", "]"}], ",", " ", 
            RowBox[{"Thickness", "[", "0.005", "]"}]}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"Length", "[", "datamerged", "]"}]}], "}"}]}], "]"}], 
        ","}], "*)"}], 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsIntensityFit.pdf\>\""}], "}"}], "]"}], ",", 
     "plotIntensityFitPlatelets"}], "]"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"plotPlateletsFit", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"slope", "[", 
         RowBox[{"datamerged", ",", "0.15"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"slope", "[", 
         RowBox[{
          RowBox[{"calculateIntensitiesLR", "[", 
           RowBox[{
           "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r"}], 
           "]"}], "/.", "fitSlopeLRResult"}], "]"}]}], "\[IndentingNewLine]", 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", " ", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Slope\>\"", ",", " ", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<\!\(\*StyleBox[\"q\",FontSlant->\"Italic\"]\) \
[\!\(\*SuperscriptBox[\(nm\), \(-1\)]\)]\>\"", ",", " ", "None"}], "}"}]}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Binned data\>\"", ",", " ", 
         "\"\<Platelets form factor fit\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "->", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "\"\<\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsSlopeFit.pdf\>\""}], "}"}], "]"}], ",", 
     "plotPlateletsFit"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plot3Dprobability", " ", "=", " ", 
    RowBox[{"ListPlot3D", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"l", ",", "r", ",", 
            RowBox[{
             RowBox[{"probfunc", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
               ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ScalingFunctions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Ticks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
         RowBox[{"PowerTicks", "[", "True", "]"}], ",", "Automatic"}], 
        "}"}]}], ",", " ", "\[IndentingNewLine]", 
      RowBox[{"AxesLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\"", ",", 
         "\"\<Probability\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "12"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"LabelStyle", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
          "}"}]}], ","}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{"ColorFunction", "->", 
         RowBox[{"(", 
          RowBox[{"ColorData", "[", "9", "]"}], ")"}]}], ","}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"BoxStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsFit3Dprobability.pdf\>\""}], "}"}], "]"}], ",", " ", 
     "plot3Dprobability"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"plot2Ddensity", " ", "=", " ", 
    RowBox[{"ListDensityPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"l", ",", "r", ",", 
            RowBox[{
             RowBox[{"probfunc", "[", 
              RowBox[{
              "\[Mu]l", ",", "\[Sigma]l", ",", "\[Mu]r", ",", "\[Sigma]r", 
               ",", "l", ",", "r"}], "]"}], "/.", "fitSlopeLRResult"}]}], 
           "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "radii"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "lengths"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ScalingFunctions", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Log\>\"", ",", "\"\<Log\>\"", ",", "None"}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Length (nm)\>\"", ",", "\"\<Radius (nm)\>\""}], "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ColorFunction", "->", "\"\<SunsetColors\>\""}], ",", " ", 
      RowBox[{"(*", 
       RowBox[{"\"\<CherryTones\>\"", ",", " ", 
        RowBox[{"\"\<SunsetColors\>\"", " ", 
         RowBox[{"(", 
          RowBox[{"one", " ", "directionally", " ", 
           RowBox[{"continuous", "/", "best"}]}], ")"}]}], ",", " ", 
        "\"\<LightTemperatureMap\>\"", ",", " ", 
        "\"\<ThermometerColors\>\""}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", " ", "Automatic"}], ",", " ", 
      RowBox[{"(*", " ", 
       RowBox[{"PlotLegends", "->", " ", 
        RowBox[{"BarLegend", "[", "\"\<SunsetColors\>\"", "]"}]}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "->", "Automatic"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletsFit2Ddensity.pdf\>\""}], "}"}], "]"}], ",", 
     "plot2Ddensity"}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotPlateletDistributions", " ", "=", " ", 
    RowBox[{"ListLogLinearPlot", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"lengths", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"LogNormalDistribution", "[", 
                RowBox[{"\[Mu]l", ",", "\[Sigma]l"}], "]"}], "/.", 
               "fitSlopeLRResult"}], ",", "lengths"}], "]"}]}]}], "}"}], 
         "\[Transpose]"}], ",", " ", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Probability", " ", "normalized", " ", "by", " ", "the", " ", 
          "maximum", " ", "probability"}], "*)"}], "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"radii", ",", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "/", 
              RowBox[{"Max", "[", "#", "]"}]}], "&"}], "@", 
            RowBox[{"PDF", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"LogNormalDistribution", "[", 
                RowBox[{"\[Mu]r", ",", "\[Sigma]r"}], "]"}], "/.", 
               "fitSlopeLRResult"}], ",", "radii"}], "]"}]}]}], "}"}], 
         "\[Transpose]"}]}], "\[IndentingNewLine]", "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", "->", " ", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "->", "All"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Size (nm)\>\"", ",", "\"\<Normalized probability\>\""}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", " ", "Automatic"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"PowerTicks", "[", "True", "]"}], ",", 
           RowBox[{"PowerTicks", "[", "False", "]"}]}], "}"}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"PlotLegends", "->", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Platelets thickness fit distribution\>\"", ",", " ", 
         "\"\<Platelets radii fit distribution\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "->", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ColorData", "[", "9", "]"}], "[", "1", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           
           TemplateBox[<|
            "color" -> RGBColor[
              0.6745098039215687, 0.07450980392156863, 0.043137254901960784`]|>,
            "RGBColorSwatchTemplate"], ",", 
           RowBox[{"PointSize", "[", "0.01", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", "Automatic"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Black", ",", " ", 
           RowBox[{"PointSize", "[", "0.04", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.004", "]"}], ",", " ", "Dashed"}], 
          "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontSize", " ", "->", " ", "14"}], ",", " ", "Black"}], 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", "Black"}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"NotebookDirectory", "[", "]"}], ",", " ", 
        "\"\<PlateletFitDistributions.pdf\>\""}], "}"}], "]"}], ",", 
     "plotPlateletDistributions"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.889083294305049*^9, 3.889083315851309*^9}, {
   3.8890833883662243`*^9, 3.8890834456873417`*^9}, {3.889083486103497*^9, 
   3.8890835217014627`*^9}, {3.889083563050894*^9, 3.8890835639046907`*^9}, {
   3.88908424900935*^9, 3.889084266338831*^9}, {3.8895047640723577`*^9, 
   3.8895048132399473`*^9}, {3.889504846884196*^9, 3.8895048547452297`*^9}, {
   3.8895049269182625`*^9, 3.8895050026520877`*^9}, {3.8895050961729617`*^9, 
   3.889505131901743*^9}, {3.8895051665115204`*^9, 3.88950517791572*^9}, {
   3.889514960971097*^9, 3.889515036411804*^9}, {3.8895151686784644`*^9, 
   3.8895152527812395`*^9}, {3.889515322726761*^9, 3.889515322942603*^9}, {
   3.889515414799749*^9, 3.889515415134011*^9}, {3.889515802135846*^9, 
   3.8895158072956295`*^9}, {3.88951762311401*^9, 3.8895176529460897`*^9}, {
   3.8895177805499964`*^9, 3.8895178521346097`*^9}, {3.8895178958654327`*^9, 
   3.889517895992517*^9}, {3.8895179853740325`*^9, 3.8895179941825094`*^9}, {
   3.889518050385213*^9, 3.8895180651462665`*^9}, {3.889518110111107*^9, 
   3.8895181537599416`*^9}, {3.8895181952428894`*^9, 3.889518231543586*^9}, {
   3.8895182640986247`*^9, 3.889518360154647*^9}, {3.889518402957049*^9, 
   3.8895184404208817`*^9}, {3.889518524888457*^9, 3.8895185272255807`*^9}, {
   3.8895889126133003`*^9, 3.889588935610735*^9}, {3.889589038336623*^9, 
   3.889589077704085*^9}, {3.889592078032647*^9, 3.8895920808209195`*^9}, {
   3.889592118364094*^9, 3.8895924083479843`*^9}, {3.8895925522801237`*^9, 
   3.8895925725829153`*^9}, {3.8895927385856147`*^9, 3.889592740371332*^9}, {
   3.8895928489211516`*^9, 3.8895928588784356`*^9}, {3.8895928981345015`*^9, 
   3.889592939760598*^9}, {3.889592994486616*^9, 3.889593006731392*^9}, {
   3.8896690677438173`*^9, 3.8896690861177497`*^9}, {3.8896691662237344`*^9, 
   3.8896691680709915`*^9}, {3.8896692820528316`*^9, 
   3.8896693106620665`*^9}, {3.889669383022016*^9, 3.8896694349828773`*^9}, {
   3.8896699958407335`*^9, 3.8896699966198225`*^9}, {3.8896701115288887`*^9, 
   3.8896701256913085`*^9}, {3.8896701570270524`*^9, 3.889670157394929*^9}, {
   3.8896712449546976`*^9, 3.889671273339734*^9}, {3.8896722465178547`*^9, 
   3.8896723216246796`*^9}, {3.889677150823584*^9, 3.889677160683831*^9}, {
   3.8896771908757315`*^9, 3.889677195202493*^9}, 3.8896773421424313`*^9, {
   3.889677378283571*^9, 3.8896773887669315`*^9}, {3.88967742719445*^9, 
   3.889677430963851*^9}, {3.889677480339917*^9, 3.889677480743126*^9}, {
   3.889677596624218*^9, 3.8896775968970366`*^9}, {3.889680706734044*^9, 
   3.8896807216712313`*^9}, {3.889680801340059*^9, 3.8896808079046683`*^9}, 
   3.8896849744898243`*^9, {3.889685151140499*^9, 3.8896851850751715`*^9}, {
   3.905229092314867*^9, 
   3.9052290995451946`*^9}},ExpressionUUID->"53db37f2-ab19-4a4d-8175-\
4749ca30cef4"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, {}, 
     {GrayLevel[0], PointSize[0.04], Thickness[0.004], LineBox[CompressedData["
1:eJwtlAk4Vfsaxg27bYjY88Rm27ZMJW4lN5o0qW6UTpxUmk6nUldSJ9J1Ghy3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       "]]}}, {
     {RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
      PointSize[0.01], Thickness[0.005], PointBox[CompressedData["
1:eJwVV3k41d/XdU13didDv1IpNHwVopSoc4hMRSGSmVRKElJSkiINMmSIBhqV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       "]]}, {}}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-5.298317366548025, -13.815510557964243`},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["\"Intensity [a.u.]\"", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) \
[\\!\\(\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], 
      TraditionalForm], None}},
  FrameTicks->{{{{
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500000], -13.122363377404328`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 3]], -12.716898269296165`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250000], -12.429216196844383`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200000], -12.206072645530174`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500000, 3]], -12.02375108873622], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 7]], -11.86960040890896], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125000], -11.736069016284437`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 9]], -11.618285980628055`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50000], -10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 3]], -10.41431317630212], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25000], -10.126631103850338`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20000], -9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50000, 3]], -9.721165995742174], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 7]], -9.567015315914915], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[12500], -9.433483923290392], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 9]], -9.315700887634009], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000000], -13.815510557964274`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500000], -13.122363377404328`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 3]], -12.716898269296165`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250000], -12.429216196844383`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200000], -12.206072645530174`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500000, 3]], -12.02375108873622], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 7]], -11.86960040890896], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125000], -11.736069016284437`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000000, 9]], -11.618285980628055`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100000], -11.512925464970229`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50000], -10.819778284410283`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 3]], -10.41431317630212], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25000], -10.126631103850338`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20000], -9.903487552536127], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50000, 3]], -9.721165995742174], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 7]], -9.567015315914915], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[12500], -9.433483923290392], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100000, 9]], -9.315700887634009], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10000], -9.210340371976184], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5000], -8.517193191416238], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 3]], -8.111728083308073], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2500], -7.824046010856292], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2000], -7.600902459542082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5000, 3]], -7.418580902748128], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 7]], -7.264430222920869], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1250], -7.1308988302963465`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10000, 9]], -7.013115794639964], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[30], 3.4011973816621555`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[70], 4.248495242049359], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[80], 4.382026634673881], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[90], 4.499809670330265], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[100], 4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[200], 5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[300], 5.703782474656201], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[400], 5.991464547107982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[500], 6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[600], 6.396929655216146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[700], 6.551080335043404], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[800], 6.684611727667927], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[900], 6.802394763324311], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}, {{{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}, {{
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
       NCache[-Log[1000], -6.907755278982137], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[500], -6.214608098422191], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 3]], -5.809142990314028], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[250], -5.521460917862246], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[200], -5.298317366548036], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[500, 3]], -5.115995809754082], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 7]], -4.961845129926823], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[125], -4.8283137373023015`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[1000, 9]], -4.710530701645918], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[100], -4.605170185988092], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[50], -3.912023005428146], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 3]], -3.506557897319982], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[25], -3.2188758248682006`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[20], -2.995732273553991], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[50, 3]], -2.8134107167600364`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 7]], -2.659260036932778], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[25, 2]], -2.5257286443082556`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[100, 9]], -2.407945608651872], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 3]], -1.2039728043259361`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 2]], -0.9162907318741551], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 3]], -0.5108256237659907], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 7]], -0.3566749439387324], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[5, 4]], -0.22314355131420976`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[-Log[
          Rational[10, 9]], -0.10536051565782635`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {0, 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[3], 1.0986122886681098`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[7], 1.9459101490553132`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[8], 2.0794415416798357`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[9], 2.1972245773362196`], 
       FormBox[
        TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{FontSize -> 14, 
    GrayLevel[0]},
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Exp[
         Part[#, 1]], 
        Exp[
         Part[#, 2]]}& )}},
  PlotRange->{{-5.298317366548036, 0.}, {-13.815510557964274`, 
   4.605170185988092}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0], 
    Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
     15.954589770191003`, RotateLabel -> 0]}]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914283344573555`*^9, 
   3.8926188577476263`*^9, 3.892619234655546*^9, 3.902367897494438*^9, 
   3.902372763150546*^9},
 CellLabel->
  "Out[2147]=",ExpressionUUID->"692e0323-b868-41e1-a8b2-8006f712abf6"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C15 - \
1.05\\\\PlateletsIntensityFit.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914283344573555`*^9, 
   3.8926188577476263`*^9, 3.892619234655546*^9, 3.902367897494438*^9, 
   3.9023727643321095`*^9},
 CellLabel->
  "Out[2148]=",ExpressionUUID->"5d1e04a5-923d-4479-91bf-a9e5319f9004"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{{Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.352012198649872, -1.3931597078962221`}, \
{-5.352012198649872, -1.151834366725471}}], 
          
          LineBox[{{-5.352012198649872, -1.151834366725471}, \
{-5.352012198649872, -0.9105090255547197}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.197327949963066, -1.3134154073527315`}, \
{-5.197327949963066, -1.069959893773818}}], 
          
          LineBox[{{-5.197327949963066, -1.069959893773818}, \
{-5.197327949963066, -0.8265043801949042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-5.046182498246482, -1.9504581230708071`}, \
{-5.046182498246482, -1.6762357931850604`}}], 
          
          LineBox[{{-5.046182498246482, -1.6762357931850604`}, \
{-5.046182498246482, -1.4020134632993138`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.894444132978499, -2.0135895487593514`}, \
{-4.894444132978499, -1.7375884675911477`}}], 
          
          LineBox[{{-4.894444132978499, -1.7375884675911477`}, \
{-4.894444132978499, -1.461587386422944}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.745125399370905, -2.1041540613861183`}, \
{-4.745125399370905, -1.8251655604291082`}}], 
          
          LineBox[{{-4.745125399370905, -1.8251655604291082`}, \
{-4.745125399370905, -1.546177059472098}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.596628633102665, -2.0307430586360637`}, \
{-4.596628633102665, -1.7724110332954253`}}], 
          
          LineBox[{{-4.596628633102665, -1.7724110332954253`}, \
{-4.596628633102665, -1.5140790079547868`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.447741719114617, -2.0169830121124313`}, \
{-4.447741719114617, -1.7725072919707168`}}], 
          
          LineBox[{{-4.447741719114617, -1.7725072919707168`}, \
{-4.447741719114617, -1.5280315718290023`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.298711959937622, -2.0626503772314857`}, \
{-4.298711959937622, -1.8496491893256315`}}], 
          
          LineBox[{{-4.298711959937622, -1.8496491893256315`}, \
{-4.298711959937622, -1.6366480014197775`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.149632905511913, -2.236616860168895}, \
{-4.149632905511913, -2.0325593608914523`}}], 
          
          LineBox[{{-4.149632905511913, -2.0325593608914523`}, \
{-4.149632905511913, -1.8285018616140096`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-4.001278268975371, -2.126596922805546}, \
{-4.001278268975371, -1.9202406735472024`}}], 
          
          LineBox[{{-4.001278268975371, -1.9202406735472024`}, \
{-4.001278268975371, -1.7138844242888587`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.8508575458258987`, -2.405553425795285}, \
{-3.8508575458258987`, -2.2031646692537383`}}], 
          
          LineBox[{{-3.8508575458258987`, -2.2031646692537383`}, \
{-3.8508575458258987`, -2.0007759127121916`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.6998351226863213`, -2.3164167395806587`}, \
{-3.6998351226863213`, -2.134158695867596}}], 
          
          LineBox[{{-3.6998351226863213`, -2.134158695867596}, \
{-3.6998351226863213`, -1.9519006521545337`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.550260154845919, -2.203216947445259}, \
{-3.550260154845919, -2.0473258241851515`}}], 
          
          LineBox[{{-3.550260154845919, -2.0473258241851515`}, \
{-3.550260154845919, -1.891434700925044}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.3997502222704012`, -2.2307861716923925`}, \
{-3.3997502222704012`, -2.0800504841837304`}}], 
          
          LineBox[{{-3.3997502222704012`, -2.0800504841837304`}, \
{-3.3997502222704012`, -1.9293147966750681`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.2492191603155653`, -2.2478328027805525`}, \
{-3.2492191603155653`, -2.1107168701832237`}}], 
          
          LineBox[{{-3.2492191603155653`, -2.1107168701832237`}, \
{-3.2492191603155653`, -1.973600937585895}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-3.099363949694378, -2.2353296307097104`}, \
{-3.099363949694378, -2.1004607688868693`}}], 
          
          LineBox[{{-3.099363949694378, -2.1004607688868693`}, \
{-3.099363949694378, -1.9655919070640282`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.9723318619592627`, -2.3858567159594695`}, \
{-2.9723318619592627`, -2.169150133472718}}], 
          
          LineBox[{{-2.9723318619592627`, -2.169150133472718}, \
{-2.9723318619592627`, -1.9524435509859663`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.8161289018458944`, -2.306313665840845}, \
{-2.8161289018458944`, -2.014061893425849}}], 
          
          LineBox[{{-2.8161289018458944`, -2.014061893425849}, \
{-2.8161289018458944`, -1.7218101210108534`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.637122953927779, -2.7518917128356595`}, \
{-2.637122953927779, -2.2061952959799984`}}], 
          
          LineBox[{{-2.637122953927779, -2.2061952959799984`}, \
{-2.637122953927779, -1.6604988791243374`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.4883394437723703`, -2.7366945816937207`}, \
{-2.4883394437723703`, -2.225953227624485}}], 
          
          LineBox[{{-2.4883394437723703`, -2.225953227624485}, \
{-2.4883394437723703`, -1.7152118735552495`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.3426491274116255`, -2.772455987224709}, \
{-2.3426491274116255`, -2.2921739832968755`}}], 
          
          LineBox[{{-2.3426491274116255`, -2.2921739832968755`}, \
{-2.3426491274116255`, -1.811891979369042}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.1952323671440643`, -2.7715253067085035`}, \
{-2.1952323671440643`, -2.329483345181388}}], 
          
          LineBox[{{-2.1952323671440643`, -2.329483345181388}, \
{-2.1952323671440643`, -1.8874413836542725`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-2.048114358050804, -2.8147049786780887`}, \
{-2.048114358050804, -2.3830075094473293`}}], 
          
          LineBox[{{-2.048114358050804, -2.3830075094473293`}, \
{-2.048114358050804, -1.95131004021657}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.9047213128625353`, -2.832278194104769}, \
{-1.9047213128625353`, -2.4311676688983095`}}], 
          
          LineBox[{{-1.9047213128625353`, -2.4311676688983095`}, \
{-1.9047213128625353`, -2.0300571436918498`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.7572185227137695`, -2.8846177931737373`}, \
{-1.7572185227137695`, -2.511398827530227}}], 
          
          LineBox[{{-1.7572185227137695`, -2.511398827530227}, \
{-1.7572185227137695`, -2.1381798618867163`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.6053998639759, -2.9663156495983545`}, \
{-1.6053998639759, -2.61370163284424}}], 
          
          LineBox[{{-1.6053998639759, -2.61370163284424}, {-1.6053998639759, \
-2.2610876160901254`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.4536487775630647`, -3.0377885868632313`}, \
{-1.4536487775630647`, -2.6973826950774096`}}], 
          
          LineBox[{{-1.4536487775630647`, -2.6973826950774096`}, \
{-1.4536487775630647`, -2.356976803291588}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.3021571254789979`, -3.144948413067255}, \
{-1.3021571254789979`, -2.8205679377033843`}}], 
          
          LineBox[{{-1.3021571254789979`, -2.8205679377033843`}, \
{-1.3021571254789979`, -2.4961874623395137`}}]}}, {Antialiasing -> False, 
         Directive[
          RGBColor[
          0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
          PointSize[0.01], 
          Thickness[0.005]], {}, {
          
          LineBox[{{-1.1509597708634107`, -3.234763455290838}, \
{-1.1509597708634107`, -2.9191367616169543`}}], 
          
          LineBox[{{-1.1509597708634107`, -2.9191367616169543`}, \
{-1.1509597708634107`, -2.6035100679430707`}}]}}}}}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005]], 
        LineBox[CompressedData["
1:eJw1lns4FWsbxheW5bgYrCzns/iilEotYbRVwpacPscolU3pICmiqOgckTOJ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         "]]}}, {{
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
         PointSize[0.01], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         InsetBox[
          BoxData[
           FormBox[
            StyleBox[
             GraphicsBox[{
               EdgeForm[], 
               DiskBox[{0, 0}]}], 
             GraphicsBoxOptions -> {DefaultBaseStyle -> Directive[
                 AbsoluteThickness[1.6], 
                 RGBColor[
                 0.9372549019607843, 0.6470588235294118, 0.6431372549019608], 
                 PointSize[0.01], 
                 Thickness[0.005]]}, StripOnInput -> False], 
            TraditionalForm]], {0., 0.}, Automatic, 
          Offset[6.272]], CompressedData["
1:eJwB5QEa/iFib1JlAwAAAB0AAAABAAAAAgAAAB76w+J1aBXAkup33+lt8r9e
to5WEMoUwJak/EOOHvG/Anf+dkovFMDO1IGf3NH6v4j3rCnpkxPALF+jkCnN
+78v3hYnAvsSwKpBfc3gM/2/7SHMnfJiEsC5LPGry1v8v8CbIs58yhHA1/gu
mzBc/L+ybEuM4TERwL6fk78pmP2/BlFOXjmZEMDbqHF7rkIAwGLHLRdPARDA
E1nVSE65/r82BKdmjs4OwAEuUcwUoAHAOz0kKEOZDcB9zVnLwRIBwEjXysvu
ZgzAQQ2ZXOxgAMDGwpk+sDILwOLIHILxowDASLx4nWb+CcBda8SGv+IAwL+1
klN/ywjAcTMnYL7NAMBiyl/tVccHwO0Im2JrWgHA8/z1lm6HBsAlEmN7zBwA
wLA0VevTGAXAx5UmuEmmAcAVy6KCHugDwByV2JDAzgHAD+Nh0769AsBdBDhQ
X1YCwA4JwPzVjwHAwgsBKsiiAsCyXtLHiWIAwOuWuT1mEAPABNIrDr15/r8c
FugICHMDwHqybyuRHfy/+6O7RFgXBMAseIzEt6/5v+CK1Gbc6ATAUw94OCVC
978DO+FgPZQFwHv4wrWi1fS/WahE7IWQBsCI6+3KVGryv8CR3V9kWgfAW2rv
UQ==
         "]]}, {
        Directive[
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6745098039215687, 0.07450980392156863, 0.043137254901960784`], 
         PointSize[0.01], 
         Thickness[0.005]], 
        GeometricTransformationBox[
         TagBox[
          InsetBox["", {0., 0.}], "InsetString"], CompressedData["
1:eJw1lnk8Vdsbxo+ZTBsnxzyE+EVIIcLWVQlXMl1TUZRLaZCEKCqUJpGZREld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         "]]}}}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-7.2705523451534315`, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
         TagBox["\"Slope\"", HoldForm], TraditionalForm], None}, {
        FormBox[
         TagBox[
         "\"\\!\\(\\*StyleBox[\\\"q\\\",FontSlant->\\\"Italic\\\"]\\) [\\!\\(\
\\*SuperscriptBox[\\(nm\\), \\(-1\\)]\\)]\"", HoldForm], TraditionalForm], 
        None}}, FrameStyle -> GrayLevel[0], 
     FrameTicks -> {{Automatic, Automatic}, {{{
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "3"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "2"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{"10", 
             RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {0, 
          FormBox[
           
           TemplateBox[{"10", "0"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           
           TemplateBox[{"10", "1"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           
           TemplateBox[{"10", "2"}, "Superscript", SyntaxForm -> 
            SuperscriptBox], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}, {{
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm]}, {
          NCache[-Log[10000], -9.210340371976184], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5000], -8.517193191416238], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 3]], -8.111728083308073], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2500], -7.824046010856292], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2000], -7.600902459542082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5000, 3]], -7.418580902748128], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 7]], -7.264430222920869], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1250], -7.1308988302963465`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10000, 9]], -7.013115794639964], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[1000], -6.907755278982137], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[500], -6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 3]], -5.809142990314028], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[250], -5.521460917862246], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[200], -5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[500, 3]], -5.115995809754082], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 7]], -4.961845129926823], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[125], -4.8283137373023015`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[1000, 9]], -4.710530701645918], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[100], -4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[50], -3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 3]], -3.506557897319982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[25], -3.2188758248682006`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[20], -2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[50, 3]], -2.8134107167600364`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 7]], -2.659260036932778], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[25, 2]], -2.5257286443082556`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[100, 9]], -2.407945608651872], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[10], -2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[5], -1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 3]], -1.2039728043259361`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 2]], -0.9162907318741551], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[2], -0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 3]], -0.5108256237659907], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 7]], -0.3566749439387324], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[5, 4]], -0.22314355131420976`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[-Log[
             Rational[10, 9]], -0.10536051565782635`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {0, 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[2], 0.6931471805599453], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[3], 1.0986122886681098`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[4], 1.3862943611198906`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[5], 1.6094379124341003`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[6], 1.791759469228055], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[7], 1.9459101490553132`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[8], 2.0794415416798357`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[9], 2.1972245773362196`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[10], 2.302585092994046], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[20], 2.995732273553991], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[30], 3.4011973816621555`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[40], 3.6888794541139363`], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[50], 3.912023005428146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[60], 4.0943445622221], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[70], 4.248495242049359], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[80], 4.382026634673881], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[90], 4.499809670330265], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[100], 4.605170185988092], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[200], 5.298317366548036], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[300], 5.703782474656201], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[400], 5.991464547107982], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[500], 6.214608098422191], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[600], 6.396929655216146], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[700], 6.551080335043404], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[800], 6.684611727667927], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}, {
          NCache[
           Log[900], 6.802394763324311], 
          FormBox[
           TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}, {
           Thickness[0.001]}}}}}, GridLines -> {None, None}, GridLinesStyle -> 
     Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> {FontSize -> 14, 
       GrayLevel[0]}, 
     Method -> {
      "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "DefaultPlotStyle" -> {
         Directive[
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.528488, 0.470624, 0.701351], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.772079, 0.431554, 0.102387], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.363898, 0.618501, 0.782349], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[1, 0.75, 0], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.647624, 0.37816, 0.614037], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.571589, 0.586483, 0.], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.915, 0.3325, 0.2125], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[
          0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
          AbsoluteThickness[1.6]], 
         Directive[
          RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
          AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
       "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> 
       Scaled[0.05], "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> 
       True, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           Exp[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-7.2705523451534315`, 
       2.2795592420641055`}, {-4.117231268934482, 0}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.02]}}, Ticks -> {
       Charting`ScaledTicks[{Log, Exp}, {Log, Exp}, "Nice", WorkingPrecision -> 
        15.954589770191003`, RotateLabel -> 0], Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"Binned data\"", "\"Platelets form factor fit\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}, {DefaultBaseStyle -> {"Graphics", {
                    AbsolutePointSize[6]}, 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608], 
                    PointSize[0.5], 
                    Thickness[0.09]]}}], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]], Automatic, 
                    Scaled[1]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 6.272}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.28196428571428567`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], {
                    InsetBox[
                    FormBox[
                    StyleBox["\"\"", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`], 
                    PointSize[0.5], 
                    Thickness[0.09]], FontSize -> 10, Plain, StripOnInput -> 
                    False], TraditionalForm], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]]]}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[-0.023999999999999994`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontSize -> 14, 
          GrayLevel[0], FontFamily -> "Arial"}, Background -> Automatic, 
         StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.9372549019607843, 0.6470588235294118, 
                    0.6431372549019608]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   TemplateBox[<|
                    "color" -> 
                    RGBColor[
                    0.6745098039215687, 0.07450980392156863, 
                    0.043137254901960784`]|>, "RGBColorSwatchTemplate"], ",", 
                   RowBox[{"PointSize", "[", "0.01`", "]"}], ",", 
                   RowBox[{"Thickness", "[", "0.005`", "]"}]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    GraphicsBox[{
                    EdgeForm[], 
                    DiskBox[{0, 0}]}], ",", 
                    RowBox[{"Offset", "[", "6.272`", "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"\"\"", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
                 
                 TemplateBox[<|"color" -> GrayLevel[0]|>, 
                  "GrayLevelColorSwatchTemplate"]}], "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914283344573555`*^9, 
   3.8926188577476263`*^9, 3.892619234655546*^9, 3.902367897494438*^9, 
   3.9023727649287214`*^9},
 CellLabel->
  "Out[2149]=",ExpressionUUID->"16da153e-f5d0-44d1-836a-7cdb49146c08"],

Cell[BoxData["\<\"C:\\\\Users\\\\s168562\\\\OneDrive - TU \
Eindhoven\\\\PhD\\\\4_Colloidal_interactions\\\\ESRF\\\\Analysis\\\\2022-08_\
new_data\\\\Analysis\\\\Full form factor fit\\\\LH-ESRF-C15 - \
1.05\\\\PlateletsSlopeFit.pdf\"\>"], "Output",
 CellChangeTimes->{
  3.8895182869567413`*^9, {3.8895183343905697`*^9, 3.8895183620551634`*^9}, {
   3.8895184150560637`*^9, 3.8895184418507495`*^9}, 3.8895185281220536`*^9, 
   3.8895889404320927`*^9, {3.8895890406246934`*^9, 3.8895890784682913`*^9}, 
   3.889592148098647*^9, 3.889592411520773*^9, 3.8895925734732924`*^9, 
   3.889592742450922*^9, 3.889592859727005*^9, 3.889592922507035*^9, 
   3.8895930087831736`*^9, 3.889668998234763*^9, 3.8896690890570593`*^9, 
   3.889669169286552*^9, 3.8896693168938737`*^9, 3.8896711091569824`*^9, 
   3.889671276253702*^9, 3.8896723301246977`*^9, 3.889677442821598*^9, 
   3.889677598100257*^9, 3.889684978194605*^9, 3.889685185804984*^9, 
   3.890204642630407*^9, 3.8902063323023443`*^9, 3.8902104829738626`*^9, 
   3.8902169904530506`*^9, 3.890217304571312*^9, 3.8902182374475017`*^9, 
   3.8909820692101192`*^9, 3.8909824066539817`*^9, 3.8909829558379273`*^9, 
   3.8914172809480352`*^9, 3.89141922718013*^9, 3.8914283344573555`*^9, 
   3.8926188577476263`*^9, 3.892619234655546*^9, 3.902367897494438*^9, 
   3.9023727662897434`*^9},
 CellLabel->
  "Out[2150]=",ExpressionUUID->"4099ecb4-7b50-4a16-878b-c39dc922bc93"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxM3XdYzn3/x/EKRTJaKKMSCqEQcp7JLCMjMrJLpGGkoVBGhRQNpaG0U0pK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